#ifndef GENERATE_H
#define GENERATE_H

class area;

class area_generator {
private:
  static bool init_is_done;

  static void init(void);

  int width, height;
  int bomb_freq;
  int bomb_lifetime;
  int wounded_enemy_count;
  int wounded_ally_count;
  int wounded_civilian_count;
  int crater_count;
  int tree_count;
  int wall_count;
  const char *text;

  void generate_h_wall(area *the_area) const;
  void generate_v_wall(area *the_area) const;
  void generate_trees(area *the_area) const;
  void generate_wounded(area *the_area, int max, int type) const;

public:
  static const int border;

  area_generator(int width, int height, const char *text);
  area_generator(
    int width, int height,
    const char *text,
    int bomb_freq,
    int bomb_lifetime,
    int wounded_enemy_count,
    int wounded_ally_count,
    int wounded_civilian_count,
    int crater_count,
    int tree_count,
    int wall_count
  );
  ~area_generator();

  void set_bomb_freq(int freq)
    { bomb_freq = freq; }
  void set_bomb_lifetime(int lifetime)
    { bomb_lifetime = lifetime; }

  void set_wounded_enemy_count(int count)
    { wounded_enemy_count = count; }
  void set_wounded_ally_count(int count)
    { wounded_ally_count = count; }
  void set_wounded_civilian_count(int count)
    { wounded_civilian_count = count; }
  void set_tree_count(int count)
    { tree_count = count; }
  void set_crater_count(int count)
    { crater_count = count; }
  void set_wall_count(int count)
    { wall_count = count; }

  area *create() const;
  const char *get_text() const
    { return text; }
};

#endif

