#ifndef		__REPLAY_H__
#define		__REPLAY_H__

#include "global.h"
#include <vector>
#include <string>

class Replay {
	public:
		enum {
			CMD_NOP,
			CMD_MPRESS,
			CMD_MRELEASE,
			CMD_MMOVE
		};

		struct Command {
			int id;
			int tick;
			int x;
			int y;

			Command();
			Command(int id, int x, int y);
		};

	protected:
		unsigned int seed;
		int tick;
		int cursor;
		int length;

		std::vector<Command> cmd;

	public:
		Replay();
		~Replay();

		int Save(std::string file);
		int Load(std::string file);
		void AddCommand(Command cmd);
		void Tick();
		void Reset();
		void Start(unsigned int seed);
		unsigned int GetSeed();
		Command NextCommand();
		int GetLength();
		int GetTick();
};

#endif		//__REPLAY_H__
