#ifndef		__GAME_WIDGET_H__
#define		__GAME_WIDGET_H__

#include "global.h"
#include "player.h"
#include "tank.h"
#include "rocket.h"
#include "drone.h"
#include "explosion.h"
#include "timepanel.h"
#include "replay.h"
#include <vector>


class GameWidget : public Widget {
	protected:
		bool playing;
		bool paused;
		bool holding_player;
		bool game_in_progress;
		bool have_highscore;

		Player player;
		Tank tank[4];
		Drone drone[4];

		std::vector<Rocket> rockets;
		std::vector<EXPLOSION *> exp;

		Replay rpl;
		Bitmap buffer;

		Bitmap cache[6];

	protected:
		void Draw(Bitmap &canvas);
		void MsgTick();
		bool MsgChar(int c);
		bool MsgWantfocus();
		void MsgStart();
		void MsgEnd();
		void MsgLPress();
		void MsgLRelease();
		void MsgMousemove(const Point &d);

		virtual void KillRocket(Rocket *r);
		virtual void KillPlayer();
		virtual void NewGame();

	public:
		GameWidget();
		virtual void StartPlaying();
		virtual void StopPlaying();
		virtual void Pause();

		TimePanel *timePanel;
};

#endif		//__GAME_WIDGET_H__
