#include "tank.h"
#include "music_player.h"
#include "global.h"

int Tank::max_light_counter = 100;
float Tank::max_speed = 1.0;
int Tank::max_shot_counter = 100;


Tank::Tank() : Object() {
}


Tank::~Tank() {
}

void Tank::Init() {
	Object::Init();
	light_counter = myrand() % max_light_counter;
	shot_counter = 0;
	SelectNewTarget();
}


void Tank::Update() {
	Object::Update();

	if (shot_counter == 0) {
		if (max.x == min.x) {
			if (fabs(pos.y - target.y) < max_speed) {
				v.y = 0;
				Shoot();
			}
		}
		else {
			if (fabs(pos.x - target.x) < max_speed) {
				v.x = 0;
				Shoot();
			}
		}
	}

	if (shot_counter > 0) {
		--shot_counter;

		if (shot_counter == 0) {
			SelectNewTarget();
		}
	}

	++light_counter;
	light_counter %= max_light_counter;
}


void Tank::Draw(BITMAP *canvas) {
	BITMAP *spr = 0;
	int sprite_index = 0;

	if (light_counter > max_light_counter/2) {
		sprite_index = 1;
	}
	else {
		sprite_index = 0;
	}

	if (shot_counter > max_shot_counter/2) {
		sprite_index += 2;
	}

	spr = tank_sprite[dir][sprite_index];

	//pivot_sprite(canvas, spr, (int)pos.x, (int)pos.y, spr->w/2, spr->h/2, dir);

	set_alpha_blender();
	draw_trans_sprite(canvas, spr, (int)pos.x - spr->w/2, (int)pos.y - spr->h/2);
}


void Tank::SelectNewTarget() {
	if (max.x == min.x) {
		target.x = pos.x;
		float dist = myrand() % (int)((max.y - min.y - 32)/2);
		dist /= 2;
		dist += (max.y - min.y)/4;
		target.y = pos.y + dist;
		if (target.y > max.y - 16) {
			target.y -= (max.y - min.y);
			target.y += 32;
		}

		if (target.y < pos.y) {
			v.y = -max_speed;
		}
		else {
			v.y = max_speed;
		}
	}
	else {
		target.y = pos.y;
		float dist = myrand() % (int)((max.x - min.x - 32)/2);
		dist /= 2;
		dist += (max.x - min.x)/4;
		target.x = pos.x + dist;
		if (target.x > max.x - 16) {
			target.x -= (max.x - min.x);
			target.x += 32;
		}

		if (target.x < pos.x) {
			v.x = -max_speed;
		}
		else {
			v.x = max_speed;
		}
	}
}


void Tank::Shoot() {
	shot_counter = max_shot_counter;

	Rocket r;
	r.pos = pos;

	if (pos.x <= 32) {
		r.pos.x = 48;
		r.min.x = 0;
		r.max.x = 480 - 48 - 8;
		r.min.y = 0;
		r.max.y = 480;
		r.v.x = 2*max_speed;
	}
	else if (pos.x >= 440) {
		r.pos.x = 480 - 48;
		r.min.x = 48 + 8;
		r.max.x = 480;
		r.min.y = 0;
		r.max.y = 480;
		r.v.x = -2*max_speed;
	}
	else if (pos.y <= 32) {
		r.pos.y = 48;
		r.min.y = 0;
		r.max.y = 480 - 48 - 8;
		r.min.x = 0;
		r.max.x = 480;
		r.v.y = 2*max_speed;
	}
	else if (pos.y >= 440) {
		r.pos.y = 480 - 48;
		r.min.y = 48 + 8;
		r.max.y = 480;
		r.min.x = 0;
		r.max.x = 480;
		r.v.y = -2*max_speed;
	}

	r.dir = dir;

	rockets->push_back(r);
	//play_sound(shot_sample, 255, 128, -100, 0);
	play_2d_sound(shot_sample, 255, -100, (int)pos.x, (int)pos.y, 240, 240);
}
