#include "global.h"
#include "replaywidget.h"
#include "music_player.h"


std::string ReplayWidget::replayToLoad = "";


ReplayWidget::ReplayWidget()
	:GameWidget()
{
}



void ReplayWidget::Draw(Bitmap &canvas) {
	GameWidget::Draw(canvas);

	if ((blink_counter/50)%2) {
		Font fnt = theSkin->GetFont(2);
		Color col = theSkin->fcol[Skin::INFO_BUTTON][3];
		Color shd = theSkin->scol[Skin::INFO_BUTTON][3];

		OutlinePrint(fnt, canvas, 4, 0, col, shd, 0, lng.GetString(STR_REPLAY_MARK).c_str());
	}
}


void ReplayWidget::KillPlayer() {
	cache[2].Destroy();

	//if (replay.GetTick() >= replay.GetLength()) {
		EXPLOSION *e = create_explosion(player_sprite[1], (int)player.pos.x, (int)player.pos.y);
		exp.push_back(e);
		//play_sound(explode_sample, 255, 128, -100, 0);
		play_2d_sound(explode_sample, 255, -100, (int)player.pos.x, (int)player.pos.y, 240, 240);
		player.dead = true;
		game_in_progress = false;
	//}
}


void ReplayWidget::MsgTick() {
	GameWidget::MsgTick();
	++blink_counter;

	while (true && !paused && playing) {
		Replay::Command cmd = replay.NextCommand();

		switch (cmd.id) {
			case Replay::CMD_NOP:
				replay.Tick();
				return;

			case Replay::CMD_MPRESS: {
				if (!paused && playing) {
					Point p = Point(cmd.x, cmd.y);
					if (player.pos.Distance2(p.x(), p.y()) < player.radius*player.radius) {
						if (!game_in_progress) {
							NewGame();
						}

						holding_player = true;
					}
				}
			}
			break;

			case Replay::CMD_MRELEASE: {
				holding_player = false;
			}
			break;

			case Replay::CMD_MMOVE: {
				if (holding_player && !player.dead) {
					player.pos.x += cmd.x;
					player.pos.y += cmd.y;
					game_in_progress = true;
				}
			}
			break;
		};
	}
}



void ReplayWidget::MsgStart() {
	GameWidget::MsgStart();
	blink_counter = 0;
	if (replay.Load(replayToLoad) != 0) {
		GetParent()->Close();
	}
	else {
		NewGame();
	}
}


void ReplayWidget::MsgLPress() {
	Widget::MsgLPress();

	if (player.dead) {
		GetParent()->Close();
	}
}


void ReplayWidget::MsgLRelease() {
	Widget::MsgLRelease();
}


void ReplayWidget::MsgMousemove(const Point &d) {
	Widget::MsgMousemove(d);
}


void ReplayWidget::NewGame() {
	int seed = replay.GetSeed();
	mysrand(seed);
	rpl.Start(seed);

	tank[0].pos.x = 30;
	tank[0].pos.y = 240;
	tank[0].min.x = 30;
	tank[0].max.x = 30;
	tank[0].min.y = 48;
	tank[0].max.y = 432;
	tank[0].dir = 1;

	tank[1].pos.x = 448;
	tank[1].pos.y = 240;
	tank[1].min.x = 448;
	tank[1].max.x = 448;
	tank[1].min.y = 48;
	tank[1].max.y = 432;
	tank[1].dir = 3;

	tank[2].pos.x = 240;
	tank[2].pos.y = 32;
	tank[2].min.x = 48;
	tank[2].max.x = 432;
	tank[2].min.y = 32;
	tank[2].max.y = 32;
	tank[2].dir = 0;

	tank[3].pos.x = 240;
	tank[3].pos.y = 448;
	tank[3].min.x = 48;
	tank[3].max.x = 432;
	tank[3].min.y = 448;
	tank[3].max.y = 448;
	tank[3].dir = 2;

	for (int i=0; i<4; i++) {
		tank[i].rockets = &rockets;
	}

	static int posx[] = { 112, 368, 112, 368 };
	static int posy[] = { 112, 112, 368, 368 };

	for (int i=0; i<4; i++) {
		drone[i].min.x = 80;
		drone[i].max.x = 400;
		drone[i].min.y = 80;
		drone[i].max.y = 400;
		drone[i].pos.x = posx[i];
		drone[i].pos.y = posy[i];
		drone[i].sprite_index = i*2;
		drone[i].dir = itofix(0);
	}

	player.min.x = 80;
	player.max.x = 400;
	player.min.y = 80;
	player.max.y = 400;
	player.pos.x = 240;
	player.pos.y = 240;

	player.Init();
	for (int i=0; i<4; i++) {
		tank[i].Init();
		drone[i].Init();
	}

	rockets.clear();
	exp.clear();
	holding_player = false;
	game_in_progress = false;
	have_highscore = false;

	if (timePanel) {
		timePanel->time = 0;
	}
}


bool ReplayWidget::MsgChar(int c) {
	if (player.dead) {
		GetParent()->Close();
		return true;
	}
	else {
		return GameWidget::MsgChar(c);
	}
}
