#ifndef		__LANGUAGE_H__
#define		__LANGUAGE_H__

#include <string>

enum {
	STR_GAMENAME_SMALL = 0,
	STR_GAMENAME_LARGE,
	STR_NYI,
	STR_BACK,
	STR_YES,
	STR_NO,
	STR_OFF,
	STR_ABOUT1,
	STR_ABOUT2,
	STR_ABOUT3,
	STR_INTRO1,
	STR_INTRO2,
	STR_INTRO3,
	STR_INTRO4,
	STR_INTRO5,
	STR_OUTRO1,
	STR_OUTRO2,
	STR_MENU_GAME,
	STR_MENU_SETTINGS,
	STR_MENU_HSC,
	STR_MENU_ABOUT,
	STR_MENU_EXIT,
	STR_SETTINGS_GFX,
	STR_SETTINGS_SOUND,
	STR_SETTINGS_CPU,
	STR_SETTINGS_LANGUAGE,
	STR_GFX_FULLSCREEN,
	STR_GFX_FRAMERATE,
	STR_GFX_VSYNC,
	STR_GFX_SHADOWS,
	STR_GFX_THEME,
	STR_SND_SOUND,
	STR_SND_MUSIC,
	STR_HSC_POS,
	STR_HSC_NAME,
	STR_HSC_DATE,
	STR_HSC_SCORE,
	STR_HSC_REPLAYS,
	STR_HSC_LOCAL,
	STR_HSC_ONLINE,
	STR_HSC_NOREPLAY,
	STR_GAME_PAUSED,
	STR_GAME_OVER,
	STR_GAME_RESULT,
	STR_GAME_ANYKEY,
	STR_GAME_REPLAY,
	STR_GAME_ENTERNAME,
	STR_HELP_TOOLTIP,
	STR_HELP_INSTRUCTIONS,
	STR_HELP_HSC,
	STR_HELP_NAME,
	STR_HELP_SCORE,
	STR_HELP_TEXT,
	STR_TIME_PANEL,
	STR_REPLAY_MARK,
	STR_CREDITS,

	STR_COUNT
};

class Language {
	public:
		std::string strings[STR_COUNT];

		int GetIndex(const std::string &name);
		void SetString(const std::string &name, const std::string &text);

	public:
		Language();
		virtual ~Language();

		const std::string GetString(int which);
		void Load(const char *path);
};

#endif		//__LANGUAGE_H__
