#include "global.h"
#include "gamewidget.h"
#include "music_player.h"
#include "online.h"
#include "replaydialog.h"

static string defName = "";
static int lastScore = 0;


GameWidget::GameWidget()
	:Widget(),
	playing(false),
	paused(false)
{
	timePanel = 0;
	NewGame();
}


Color DarkenColor(Color &c) {
	int r = c.r();
	int g = c.g();
	int b = c.b();
	float h,s,v;

	rgb_to_hsv(r,g,b, &h,&s,&v);
	v *= 0.5;
	hsv_to_rgb(h,s,v, &r,&g,&b);

	return Color(r,g,b);
}

Color BrightenColor(Color &c) {
	int r = c.r();
	int g = c.g();
	int b = c.b();
	float h,s,v;

	rgb_to_hsv(r,g,b, &h,&s,&v);
	v += (1.0 - v)/2;
	hsv_to_rgb(h,s,v, &r,&g,&b);

	return Color(r,g,b);
}


void DrawButton(Bitmap &bmp, Color &c0, Color &c1, Color &c2) {
	Gradient(bmp, 0, 0, bmp.w(), bmp.h(), c2, c1);
	Color c3 = DarkenColor(c1);
	Color c4 = BrightenColor(c2);
	rect(bmp, 0, 0, bmp.w()-1, bmp.h()-1, c0);
	hline(bmp, 1, 1, bmp.w()-2, c4);
	vline(bmp, 1, 1, bmp.h()-2, c4);
	hline(bmp, 2, bmp.h()-2, bmp.w()-2, c3);
	vline(bmp, bmp.w()-2, 1, bmp.h()-2, c3);
}


void GameWidget::Draw(Bitmap &canvas) {
	buffer.Blit(canvas, 0, 0, 0, 0, buffer.w(), buffer.h());

	for (int i=0; i<4; i++) {
		tank[i].Draw(canvas);
	}

	for (int i=0; i<rockets.size(); i++) {
		rockets[i].Draw(canvas);
	}

	for (int i=0; i<4; i++) {
		drone[i].Draw(canvas);
	}

	// player
	if (playing) {
		player.Draw(canvas);
	}

	for (std::vector<EXPLOSION *>::iterator e = exp.begin(); e != exp.end(); ++e) {
		draw_explosion(*e, canvas);
	}

	// overlays
	Font fnt = theSkin->GetFont(2);
	Color col = theSkin->fcol[Skin::INFO_BUTTON][3];
	Color shd = theSkin->scol[Skin::INFO_BUTTON][3];
	int ww;
	int hh = fnt.TextHeight() + 4;

	// paused message
	if (!cache[0]) {
		ww = fnt.TextLength(lng.GetString(STR_GAME_PAUSED).c_str()) + 16;
		cache[0].Create(ww, hh);
		DrawButton(cache[0], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[0], ww/2, 2, col, shd, 2, lng.GetString(STR_GAME_PAUSED).c_str());
	}

	// game over message
	if (!cache[1]) {
		ww = fnt.TextLength(lng.GetString(STR_GAME_OVER).c_str()) + 16;
		cache[1].Create(ww, hh);
		DrawButton(cache[1], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[1], ww/2, 2, col, shd, 2, lng.GetString(STR_GAME_OVER).c_str());
	}

	// result message
	if (!cache[2]) {
		int time = timePanel->time;
		int min = time/(60*100);
		int sec = time/100 - min*60;
		int msec = time - sec*100 - min*60*100;
		static char buf[256];
		usprintf(buf, lng.GetString(STR_GAME_RESULT).c_str(), min, sec, msec);

		ww = fnt.TextLength(buf) + 16;
		cache[2].Create(ww, hh);
		DrawButton(cache[2], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[2], ww/2, 2, col, shd, 2, buf);
	}

	// any key message
	if (!cache[3]) {
		ww = fnt.TextLength(lng.GetString(STR_GAME_ANYKEY).c_str()) + 16;
		cache[3].Create(ww, hh);
		DrawButton(cache[3], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[3], ww/2, 2, col, shd, 2, lng.GetString(STR_GAME_ANYKEY).c_str());
	}

	// replay message
	if (!cache[4]) {
		ww = fnt.TextLength(lng.GetString(STR_GAME_REPLAY).c_str()) + 16;
		cache[4].Create(ww, hh);
		DrawButton(cache[4], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[4], 8, 2, col, shd, 0, lng.GetString(STR_GAME_REPLAY).c_str());
	}

	// enter name message
	if (!cache[5]) {
		ww = fnt.TextLength(lng.GetString(STR_GAME_ENTERNAME).c_str()) + 16;
		cache[5].Create(ww, hh);
		DrawButton(cache[5], theme.text_button_shd, theme.back_top, theme.back_bottom);
		OutlinePrint(fnt, cache[5], ww/2, 2, col, shd, 2, lng.GetString(STR_GAME_ENTERNAME).c_str());
	}

	if (paused) {
		cache[0].Blit(canvas, Point(0,0), Point((w() - cache[0].w())/2, 40 + (h() - cache[0].h())/2), cache[0].size());
	}
	else if (!game_in_progress && player.dead) {
		cache[1].Blit(canvas, Point(0,0), Point((w() - cache[1].w())/2, -10 + (h() - cache[1].h())/2), cache[1].size());
		cache[2].Blit(canvas, Point(0,0), Point((w() - cache[2].w())/2,  40 + (h() - cache[2].h())/2), cache[2].size());

		if (!have_highscore) {
			cache[3].Blit(canvas, Point(0,0), Point((w() - cache[3].w())/2,  90 + (h() - cache[3].h())/2), cache[3].size());
			cache[4].Blit(canvas, Point(0,0), Point(4,4), cache[4].size());
		}
		else {
			cache[5].Blit(canvas, Point(0,0), Point((w() - cache[5].w())/2 - 60,  90 + (h() - cache[5].h())/2), cache[5].size());
		}
	}
}


void GameWidget::KillRocket(Rocket *r) {
	EXPLOSION *e = create_explosion(rocket_sprite[r->dir], (int)r->pos.x, (int)r->pos.y);
	exp.push_back(e);
	//play_sound(explode_sample, 128, 128, -100, 0);
	play_2d_sound(explode_sample, 128, -100, (int)r->pos.x, (int)r->pos.y, 240, 240);
}


void FixupString(std::string &str) {
	int len = str.length();
	for (int i=0; i<len; i++) {
		if (!((str[i] >= 'A' && str[i] <= 'Z') || (str[i] >= 'a' && str[i] <= 'z') || (str[i] >= '0' && str[i] <= '9') || (str[i] == ' '))) {
			str[i] = '_';
		}
	}
}


void GameWidget::KillPlayer() {
	cache[2].Destroy();

	EXPLOSION *e = create_explosion(player_sprite[1], (int)player.pos.x, (int)player.pos.y);
	exp.push_back(e);
	//play_sound(explode_sample, 255, 128, -100, 0);
	play_2d_sound(explode_sample, 255, -100, (int)player.pos.x, (int)player.pos.y, 240, 240);
	player.dead = true;
	game_in_progress = false;

	holding_player = false;
	player.pos.x = 240;
	player.pos.y = 240;

DEBUG
	if (local_hsc->CanAdd(timePanel->time)) {
DEBUG
		have_highscore = true;
		Window dlg;
		dlg.ClearFlag(D_MOVABLE);
		EditBox edit;
		Font fnt = theSkin->GetFont(2);
		dlg.Shape(w()/2+136, 90+(h() - fnt.TextHeight())/2, 176, 32);
		dlg.GetClientArea()->Resize(dlg.w(), dlg.h());
		edit.Setup(0, 0, dlg.w(), dlg.h(), 0, 0, defName.c_str(), 16);
		edit.MakeExit();
		/*
		for (int i=0; i<4; i++)
			edit.SetFontColor(Color::green, Color::black, i);
		*/
		dlg.Add(edit);
		dlg.Popup(GetParent()->Root(), dlg.x(), dlg.y(), &edit);
		defName = edit.GetText();

		if (defName != "") {
			FixupString(defName);
			HSC::Entry e;
			e.name = defName.c_str();
			e.score = timePanel->time;
			local_hsc->AddEntry(e);
			static char full[256];
			MakeFullPath(full, "dodger.hsc");
			local_hsc->Save(full);

			char tmp[8];
			usprintf(tmp, "%d", e.score);
			std::string rplName = "replays/" + defName + "-" + tmp + ".rpl";
			MakeFullPath(full, rplName.c_str());
			rpl.Save(full);

			lastScore = e.score;

			if (local_hsc->HasTopScore(e)) {
				if (hsc->CanAdd(e.score) && hsc->HasTopScore(e)) {
					hsc->AddEntry(e);
					MakeFullPath(full, "dodger_online.hsc");
					hsc->Save(full);
				}

				UploadEntry(e);
				DownloadHSC();
			}
			GetParent()->HandleEvent(*this, 2001);
		}

		have_highscore = false;
	}
	else {
		lastScore = timePanel->time;
	}
}


void GameWidget::MsgTick() {
	Widget::MsgTick();

	if (!paused && playing) {
		if (game_in_progress) {
			rpl.Tick();
		}

		player.Update();

		if (game_in_progress && !player.dead) {
			timePanel->time += 1;
		}

		if (game_in_progress) {
			for (int i=0; i<4; i++) {
				tank[i].Update();
			}

			for (int i=0; i<4; i++) {
				drone[i].Update();
			}
		}

		for (std::vector<Rocket>::iterator r = rockets.begin(); r != rockets.end(); ) {
			r->Update();

			// see if a rocket hit a wall
			if (r->pos.x == r->min.x || r->pos.x == r->max.x || r->pos.y == r->min.y || r->pos.y == r->max.y) {
				KillRocket(&*r);
				r = rockets.erase(r);
			}
			else {
				bool erased = false;

				// check collision with drones
				for (int i=0; i<4; i++) {
					if (r->CollidesWith(&drone[i])) {
						KillRocket(&*r);
						r = rockets.erase(r);
						erased = true;
						break;
					}
				}

				// check collision with player
				if (!erased && !player.dead) {
					if (r->CollidesWith(&player)) {
						KillRocket(&*r);
						r = rockets.erase(r);
						erased = true;
						KillPlayer();
						return;
					}
				}

				if (!erased) {
					++r;
				}
			}
		}

		if (!player.dead) {
			// check if player out of bounds
			if (player.pos.x < player.min.x || player.pos.x > player.max.x || player.pos.y < player.min.y || player.pos.y > player.max.y) {
				KillPlayer();
			}

			// check if player collides with drone
			for (int i=0; i<4; i++) {
				if (player.CollidesWith(&drone[i])) {
					KillPlayer();
					break;
				}
			}
		}

		for (std::vector<EXPLOSION *>::iterator e = exp.begin(); e != exp.end(); ) {
			if (update_explosion(*e) == 1) {
				destroy_explosion(*e);
				e = exp.erase(e);
			}
			else {
				++e;
			}
		}
	}
}


void GameWidget::StartPlaying() {
	playing = true;
	NewGame();
}


void GameWidget::StopPlaying() {
	playing = false;
	holding_player = false;
	game_in_progress = false;
}


void GameWidget::Pause() {
	paused = !paused;
}


bool GameWidget::MsgChar(int c) {
	Widget::MsgChar(c);

	if (player.dead) {
		if ((c>>8 == KEY_R) /* && !local_hsc->CanAdd(lastScore) */) {
			char tmp[8];
			usprintf(tmp, "%d", lastScore);
			std::string rplName = std::string("replays/") + tmp + ".rpl";
			char full[256];
			MakeFullPath(full, rplName.c_str());
			rpl.Save(full);
			ReplayWidget::replayToLoad = std::string(full);
			ReplayDialog::nextDialog = S_PLAYING;
			GetParent()->HandleEvent(*this, 2003);
		}
		else {
			NewGame();
		}
		return true;
	}

	switch (c>>8) {
		case KEY_ESC:
		case KEY_P:
			Pause();
		break;

		case KEY_Q:
			if (paused) {
				Pause();
				StopPlaying();
				GetParent()->Close();
			}
		break;

		case KEY_C:
			if (paused) {
				Pause();
			}
		break;

		default:
			return false;
	};

	return true;
}


bool GameWidget::MsgWantfocus() {
	Widget::MsgWantfocus();
	return playing;
}



void GameWidget::MsgStart() {
	Widget::MsgStart();
	/*
	SetAnimationProperties(500, Animator::SLIDE_LEFT);
	ResetAnimation();
	Animate();
	*/

	buffer.Create(SCREEN_W, SCREEN_H);
	Gradient(buffer, 0, 0, w()-1, h(), theme.back_top, theme.back_bottom);
	masked_blit(back_tile, buffer, 0, 0, 8, 8, 464, 464);

	for (int i=0; i<6; i++) {
		cache[i].Destroy();
	}
}


void GameWidget::MsgEnd() {
	Widget::MsgEnd();
	buffer.Destroy();
}


void GameWidget::MsgLPress() {
	Widget::MsgLPress();

	if (!paused && playing) {
		Point p = GetMousePos();
		if (player.pos.Distance2(p.x(), p.y()) < player.radius*player.radius) {
			if (!game_in_progress) {
				NewGame();
			}

			rpl.AddCommand(Replay::Command(Replay::CMD_MPRESS, p.x(), p.y()));
			holding_player = true;
		}
	}

	if (player.dead) {
		NewGame();
	}
}


void GameWidget::MsgLRelease() {
	Widget::MsgLRelease();
	holding_player = false;

	if (!paused && playing) {
		rpl.AddCommand(Replay::Command(Replay::CMD_MRELEASE, 0, 0));
	}
}


void GameWidget::MsgMousemove(const Point &d) {
	Widget::MsgMousemove(d);

	if (!paused) {
		if (holding_player && !player.dead) {
			player.pos.x += d.x();
			player.pos.y += d.y();
			game_in_progress = true;
			rpl.AddCommand(Replay::Command(Replay::CMD_MMOVE, d.x(), d.y()));
		}
	}
}


void GameWidget::NewGame() {
	int seed = time(0);
	mysrand(seed);
	rpl.Start(seed);

	tank[0].pos.x = 30;
	tank[0].pos.y = 240;
	tank[0].min.x = 30;
	tank[0].max.x = 30;
	tank[0].min.y = 48;
	tank[0].max.y = 432;
	tank[0].dir = 1;

	tank[1].pos.x = 448;
	tank[1].pos.y = 240;
	tank[1].min.x = 448;
	tank[1].max.x = 448;
	tank[1].min.y = 48;
	tank[1].max.y = 432;
	tank[1].dir = 3;

	tank[2].pos.x = 240;
	tank[2].pos.y = 32;
	tank[2].min.x = 48;
	tank[2].max.x = 432;
	tank[2].min.y = 32;
	tank[2].max.y = 32;
	tank[2].dir = 0;

	tank[3].pos.x = 240;
	tank[3].pos.y = 448;
	tank[3].min.x = 48;
	tank[3].max.x = 432;
	tank[3].min.y = 448;
	tank[3].max.y = 448;
	tank[3].dir = 2;

	for (int i=0; i<4; i++) {
		tank[i].rockets = &rockets;
	}

	static int posx[] = { 112, 368, 112, 368 };
	static int posy[] = { 112, 112, 368, 368 };

	for (int i=0; i<4; i++) {
		drone[i].min.x = 80;
		drone[i].max.x = 400;
		drone[i].min.y = 80;
		drone[i].max.y = 400;
		drone[i].pos.x = posx[i];
		drone[i].pos.y = posy[i];
		drone[i].sprite_index = i*2;
		drone[i].dir = itofix(0);
	}

	player.min.x = 80;
	player.max.x = 400;
	player.min.y = 80;
	player.max.y = 400;
	player.pos.x = 240;
	player.pos.y = 240;

	player.Init();
	for (int i=0; i<4; i++) {
		tank[i].Init();
		drone[i].Init();
	}

	rockets.clear();
	exp.clear();
	holding_player = false;
	game_in_progress = false;
	have_highscore = false;

	if (timePanel) {
		timePanel->time = 0;
	}

	lastScore = 0;
}
