#include "timepanel.h"


TimePanel::TimePanel() : Panel(), time(0) {
}


void TimePanel::MsgStart() {
	Panel::MsgStart();
	cache.Destroy();
}


void TimePanel::Draw(Bitmap &canvas) {
	Font fnt = theSkin->GetFont(2);
	Color col = theSkin->fcol[Skin::INFO_BUTTON][0];
	Color shd = theSkin->scol[Skin::INFO_BUTTON][0];

	if (!cache) {
		cache.Create(w(), h());
		cache.Clear(Color::magenta);

		Panel::Draw(cache);
		OutlinePrint(fnt, cache, w()/2, 4, col, shd, 2, lng.GetString(STR_TIME_PANEL).c_str());
	}

	cache.MaskedBlit(canvas, Point(0,0), Point(0,0), cache.size());

	int min = time/(60*100);
	int sec = time/100 - min*60;
	int msec = time - sec*100 - min*60*100;

	static char buf[64];
	usprintf(buf, "%01d:%02d.%02d", min, sec, msec);

	col = theSkin->fcol[Skin::INFO_BUTTON][3];
	shd = theSkin->scol[Skin::INFO_BUTTON][3];
	OutlinePrint(fnt, canvas, 12, 44, col, shd, 0, buf);
}
