#include "player.h"
#include "global.h"

int Player::max_light_counter = 100;

Player::Player() : Object() {
	radius = 28;
	dead = false;
}


Player::~Player() {
}


void Player::Init() {
	Object::Init();
	light_counter = myrand() % max_light_counter;
	dead = false;
}


void Player::Update() {
	//Object::Update();

	++light_counter;
	light_counter %= max_light_counter;
}


void Player::Draw(BITMAP *canvas) {
	if (dead) return;

	BITMAP *spr = 0;
	BITMAP *shd = 0;
	int sprite_index = 0;

	if (light_counter > max_light_counter/2) {
		++sprite_index;
	}

	spr = player_sprite[sprite_index];
	shd = player_sprite_shd[sprite_index];

	set_alpha_blender();
	if (MAS::Settings::colorDepth == 32 && shadows) {
		draw_trans_sprite(canvas, shd, (int)pos.x - spr->w/2 + 6, (int)pos.y - spr->h/2 + 4);
	}
	draw_trans_sprite(canvas, spr, (int)pos.x - spr->w/2, (int)pos.y - spr->h/2);
}
