#include "mainmenu.h"


MainMenu::MainMenu() : GameDialog() {
	// first add a desktop
	desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
	Add(desktop);

	int dy = 12;
	int y = 10-dy;
	int h = 10;
	int x = 10;
	int w = 80;

	y += dy;
	Add(globalWidgets->title);

	// add all the buttons; note that the buttons make the dialog exit when pushed
	y = 18;
	for (int i=0; i<5; i++) {
		btn[i].Shape(x, y+=dy, w, h, 1);
		btn[i].MakeExit();
		btn[i].AlignCentre();
		Add(btn[i]);
	}

	Add(globalWidgets->lblBottom);
	Add(anim);

	escapeExits = false;
}


void MainMenu::SetLanguage() {
	const char *bTitle[] = {
		lng.GetString(STR_MENU_GAME).c_str(),
		lng.GetString(STR_MENU_SETTINGS).c_str(),
		lng.GetString(STR_MENU_HSC).c_str(),
		lng.GetString(STR_MENU_ABOUT).c_str(),
		lng.GetString(STR_MENU_EXIT).c_str()
	};

	for (int i=0; i<5; i++) {
		btn[i].SetText(bTitle[i]);
	}
}


int MainMenu::Run() {
	Widget *obj = Execute(&btn[0]);

	// find out which button was pushed and return the ID of the matching next state
	for (int i=0; i<4; i++) {
		if (obj == &btn[i]) {
			GiveFocusTo(&btn[i]);
			return i+1;
		}
	}

	return S_OUTRO;
}
