#include "replay.h"

Replay::Replay() {
	Reset();
}

Replay::~Replay() {
	cmd.clear();
}


Replay::Command::Command() {
	this->id = Replay::CMD_NOP;
	this->tick = 0;
	this->x = 0;
	this->y = 0;
}


Replay::Command::Command(int id, int x, int y) {
	this->id = id;
	this->x = x;
	this->y = y;
	tick = 0;
}


int Replay::Save(std::string file) {
	packfile_password("whateva");
	PACKFILE *f = pack_fopen(file.c_str(), "wp");
	if (!f) {
		packfile_password(0);
		return 1;
	}

	pack_fwrite("RPLY", 4, f);
	pack_fwrite(&seed, sizeof(int), f);
	pack_fwrite(&length, sizeof(int), f);

	for (int i=0; i<cmd.size(); i++) {
		Command c = cmd[i];

		unsigned char ctmp = 0;
		ctmp |= (c.id & ((1<<8) - 1));
		pack_fwrite(&ctmp, sizeof(char), f);

		unsigned int tmp = 0;
		tmp |= (c.tick & ((1<<14) - 1));
		if (c.id == CMD_MMOVE) {
			c.x += 128;
			c.y += 128;
		}
		tmp |= (((c.x) & ((1<<9) - 1)) << 14);
		tmp |= (((c.y) & ((1<<9) - 1)) << 23);
		pack_fwrite(&tmp, sizeof(int), f);
	}

	pack_fclose(f);
	packfile_password(0);
	return 0;
}


int Replay::Load(std::string file) {
	packfile_password("whateva");
	PACKFILE *f = pack_fopen(file.c_str(), "rp");
	if (!f) {
		packfile_password(0);
		return 1;
	}

	char buf[4];
	pack_fread(buf, 4, f);
	if (ustrncmp(buf, "RPLY", 4) != 0) {
		pack_fclose(f);
		packfile_password(0);
		return 1;
	}

	Reset();
	pack_fread(&seed, sizeof(int), f);
	pack_fread(&length, sizeof(int), f);
	tick = 0;

	while (!pack_feof(f)) {
		Command c;

		unsigned char ctmp = 0;
		pack_fread(&ctmp, sizeof(char), f);
		c.id = ctmp;

		unsigned int tmp = 0;
		pack_fread(&tmp, sizeof(int), f);
		c.tick = tmp & ((1<<14) - 1);
		c.x = (tmp >> 14) & ((1<<9) - 1);
		c.y = (tmp >> 23) & ((1<<9) - 1);
		if (c.id == CMD_MMOVE) {
			c.x -= 128;
			c.y -= 128;
		}

		cmd.push_back(c);
	}

	pack_fclose(f);
	packfile_password(0);
	return 0;
}


void Replay::AddCommand(Command c) {
	c.tick = tick;
	cmd.push_back(c);
}


void Replay::Tick() {
	++tick;

	if (tick > length) {
		length = tick;
	}
}


void Replay::Reset() {
	seed = 0;
	tick = 0;
	cmd.clear();
	cursor = 0;
	length = 0;
}


void Replay::Start(unsigned int seed) {
	int l = length;
	Reset();
	this->seed = seed;
	this->length = l;
}


unsigned int Replay::GetSeed() {
	return seed;
}


Replay::Command Replay::NextCommand() {
	Command ret;

	if (cursor < cmd.size() && cmd[cursor].tick == tick) {
		ret = cmd[cursor];
		++cursor;
	}

	return ret;
}


int Replay::GetLength() {
	return length;
}


int Replay::GetTick() {
	return tick;
}
