#include <math.h>
#include "global.h"
#include "mainmenu.h"
#include "gamedialog.h"
#include "replaydialog.h"
#include "music_player.h"
#include "online.h"
#include <algorithm>

//------------------------------------------------------------------------------------


// Placeholder for dialogs that have not yet been implemented.
class DialogNYI : public GameDialog {
	private:
		Background desktop;
		TextButton bBack;

	public:
		DialogNYI() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			int dy = 12;
			int y = 48-dy;
			int h = 10;
			int x = 10;
			int w = 80;

			bBack.Shape(x, y+=dy, w, h, 1);
			bBack.MakeExit();
			bBack.AlignCentre();
			Add(bBack);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);
		}

		int Run() {
			Widget *obj = Execute(&bBack);
			return S_MAIN_MENU;
		}

		void SetLanguage() {
			GameDialog::SetLanguage();
			bBack.SetText(lng.GetString(STR_NYI).c_str());
		}
};


class DialogAbout : public GameDialog {
	private:
		Background desktop;
		TextButton line[3];
		TextButton bBack;

	public:
		DialogAbout() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			int dy = 12;
			int y = 30-dy;
			int h = 10;
			int x = 0;
			int w = 100;

			for (int i=0; i<3; i++) {
				line[i].ClearFlag(D_AUTOSIZE);
				line[i].Shape(x, y+=dy, w, h, 1);
				line[i].AlignCentre();
				line[i].Disable();
				Add(line[i]);
			}

			y += dy;
			bBack.Shape(x, y+=dy, w, h, 1);
			bBack.MakeExit();
			bBack.AlignCentre();
			Add(bBack);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();
			const char *text[] = {
				lng.GetString(STR_ABOUT1).c_str(),
				lng.GetString(STR_ABOUT2).c_str(),
				lng.GetString(STR_ABOUT3).c_str()
			};

			char buf[64];
			usprintf(buf, text[0], DODGER_VERSION_MAJOR, DODGER_VERSION_MINOR);
			line[0].SetText(buf);
			for (int i=1; i<3; i++) {
				line[i].SetText(text[i]);
			}

			bBack.SetText(lng.GetString(STR_BACK).c_str());
		}

		int Run() {
			Widget *obj = Execute(&bBack);
			return S_MAIN_MENU;
		}
};


int rpl_insert(const char *filename, int attrib, void *param) {
	attrib = 0;
	ListBoxEx *lst = (ListBoxEx *)param;
	int i = lst->GetItemCount();
	lst->InsertItem(new HscItem(i%2));
	lst->SetItem(i, 0, get_filename(filename));
	return 0;
}


class DialogHSC : public GameDialog {
	private:
		Background desktop;
		ListBoxEx lstHsc;
		ListBoxEx lstRpl;
		HscHeader hscHeader;
		HscHeader rplHeader;
		TextButton bBack;
		TextButton btnLocal;
		TextButton btnOnline;
		int ret;

		HSC *current_hsc;

	protected:
		void MsgInitSkin() {
			GameDialog::MsgInitSkin();

			for (int i=0; i<4; i++) {
				lstHsc.SetFont(1, i);
				lstHsc.SetFontColor(theme.hsc_list_col, theme.hsc_list_shd, i);
				lstHsc.GetHeader()->SetFont(1, i);
				lstHsc.GetHeader()->SetFontColor(theme.hsc_header_col, theme.hsc_header_shd, i);

				lstRpl.SetFont(1, i);
				lstRpl.SetFontColor(theme.rpl_list_col, theme.rpl_list_shd, i);
				lstRpl.GetHeader()->SetFont(1, i);
				lstRpl.GetHeader()->SetFontColor(theme.rpl_header_col, theme.rpl_header_shd, i);
			}
		}

	public:
		DialogHSC() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			lstHsc.Shape(16, 112, 438, 280);
			lstHsc.SetHeader(&hscHeader);
			lstHsc.InsertColumn("-", 0, 2);
			lstHsc.InsertColumn("-", 1, 2);
			lstHsc.InsertColumn("-", 2, 2);
			lstHsc.InsertColumn("-", 3, 2);
			lstHsc.SetColumnWidth(0, 48);
			lstHsc.SetColumnWidth(1, 180);
			lstHsc.SetColumnWidth(2, 100);
			lstHsc.SetColumnWidth(3, 90);
			lstHsc.EnableColumnResizing(false);
			//lstHsc.SetTooltipText("Double click a highscore to view the replay if available");
			Add(lstHsc);

			lstRpl.Shape(470, 112, 154, 280);
			lstRpl.SetHeader(&rplHeader);
			lstRpl.InsertColumn("-", 0, 2);
			lstRpl.EnableColumnResizing(false);
			Add(lstRpl);

			bBack.Shape(     5+2, 83, 30-4, 10, 1);
			btnLocal.Shape( 35+2, 83, 30-4, 10, 1);
			btnOnline.Shape(65+2, 83, 30-4, 10, 1);

			bBack.AlignCentre();
			btnLocal.AlignCentre();
			btnOnline.AlignCentre();

			btnLocal.SetFlag(D_TOGGLE);
			btnOnline.SetFlag(D_TOGGLE);
			btnOnline.Select();

			Add(bBack);
			Add(btnLocal);
			Add(btnOnline);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);

			current_hsc = hsc;
		}

		~DialogHSC() {
			lstHsc.SetHeader(0);
			lstRpl.SetHeader(0);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();

			lstHsc.SetColumnTitle(0, lng.GetString(STR_HSC_POS).c_str());
			lstHsc.SetColumnTitle(1, lng.GetString(STR_HSC_NAME).c_str());
			lstHsc.SetColumnTitle(2, lng.GetString(STR_HSC_DATE).c_str());
			lstHsc.SetColumnTitle(3, lng.GetString(STR_HSC_SCORE).c_str());
			lstRpl.SetColumnTitle(0, lng.GetString(STR_HSC_REPLAYS).c_str());

			bBack.SetText(lng.GetString(STR_BACK).c_str());
			btnLocal.SetText(lng.GetString(STR_HSC_LOCAL).c_str());
			btnOnline.SetText(lng.GetString(STR_HSC_ONLINE).c_str());
		}

		int Run() {
			FillList(current_hsc);
			FillRplList();
			ret = S_MAIN_MENU;
			Widget *obj = Execute(&bBack);
			return ret;
		}

		void FillList(HSC *hsc) {
			int sel = lstHsc.GetSelectedIndex();
			lstHsc.DeleteAllItems();
			for (int i=0; i<hsc->Count(); i++) {
				lstHsc.InsertItem(new HscItem(i%2));

				HSC::Entry e = hsc->GetEntry(i);
				static char buf[16];

				usprintf(buf, "%d", i+1);
				lstHsc.SetItem(i, 0, buf);
				lstHsc.SetItem(i, 1, e.name.c_str());
				lstHsc.SetItem(i, 2, e.date.c_str());
				int min = e.score/(60*100);
				int sec = e.score/100 - min*60;
				int msec = e.score - sec*100 - min*60*100;
				usprintf(buf, "%01d:%02d.%02d", min, sec, msec);
				lstHsc.SetItem(i, 3, buf);
			}
			if (sel >= 0) lstHsc.Select(sel);
		}

		void FillRplList() {
			int sel = lstRpl.GetSelectedIndex();
			lstRpl.DeleteAllItems();
			char full[256];
			MakeFullPath(full, "replays/*.rpl");
			for_each_file_ex(full, 0, 0, rpl_insert, &lstRpl);
			if (sel >= 0) lstHsc.Select(sel);
		}

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			GameDialog::HandleEvent(obj, msg, arg1, arg2);

			if (msg == MSG_ACTIVATE) {
				if (obj == lstHsc) {
					ListBoxEx::Item *item = lstHsc.GetSelectedItem();
					if (item) {
						const char *name = item->GetText(1);
						const char *time = item->GetText(3);
						char tmp[64];
						ustrcpy(tmp, time);
						char *tok = ustrtok(tmp, ":");
						int min = (int)uatof(tok);
						tok = ustrtok(0, ".");
						int sec = (int)uatof(tok);
						tok = ustrtok(0, ".");
						int hun = (int)uatof(tok);
						int score = hun + 100*sec + 100*60*min;
						usprintf(tmp, "replays/%s-%d.rpl", name, score);
						char full[256];
						MakeFullPath(full, tmp);
						if (exists(full)) {
							ReplayWidget::replayToLoad = full;
							ReplayDialog::nextDialog = S_HIGHSCORES;
							ret = S_REPLAY;
							Close();
						}
						else {
							Window dlg;
							dlg.ClearFlag(D_MOVABLE);
							TextButton btn;
							dlg.Resize(460, 32);
							dlg.GetClientArea()->Resize(dlg.w(), dlg.h());
							btn.Setup(0, 0, dlg.w(), dlg.h(), 0, 0, lng.GetString(STR_HSC_NOREPLAY).c_str());
							btn.MakeExit();
							dlg.Add(btn);
							dlg.Centre();
							dlg.Popup(Root(), dlg.x(), dlg.y(), &btn);
						}
					}
				}
				else if (obj == lstRpl) {
					ListBoxEx::Item *item = lstRpl.GetSelectedItem();
					if (item) {
						const char *name = item->GetText(0);
						char tmp[64];
						usprintf(tmp, "replays/%s", name);
						char full[256];
						MakeFullPath(full, tmp);
						ReplayWidget::replayToLoad = full;
						ReplayDialog::nextDialog = S_HIGHSCORES;
						ret = S_REPLAY;
						Close();
					}
				}
				else if (obj == bBack) {
					ret = S_MAIN_MENU;
					Close();
				}
				else if (obj == btnLocal) {
					if (btnLocal.Selected()) {
						current_hsc = local_hsc;
						FillList(current_hsc);
						btnOnline.Deselect();
					}
					else {
						btnLocal.Select();
					}
				}
				else if (obj == btnOnline) {
					if (btnOnline.Selected()) {
						current_hsc = hsc;
						FillList(current_hsc);
						btnLocal.Deselect();
					}
					else {
						btnOnline.Select();
					}
				}
			}
		}
};


/*
class IntroScreen : public GameDialog {
	private:
		Background desktop;
		int counter;

		Label lbl[32];

	public:
		IntroScreen() : GameDialog() {
			Add(desktop);

			int dy = 8;
			int x = 10;
			int w = 620;
			int y = 120;
			int h = 360;

			for (int i=0; i<32; i++) {
				lbl[i].ClearFlag(D_AUTOSIZE);
				lbl[i].Shape(x, y+=dy, w, 14);
				Add(lbl[i]);
			}

			Add(anim);
		}

		int Run() {
			counter = 0;
			play_music(0);
			MAS::Settings::showMouse = false;
			Widget *obj = Execute();
			MAS::Settings::showMouse = true;
			return S_MAIN_MENU;
		}

		void MsgInitSkin() {
			GameDialog::MsgInitSkin();

			for (int i=0; i<32; i++) {
				lbl[i].SetFont(2, 0);
				lbl[i].SetFontColor(Color(0,192,0), Color::black, 0);
			}
		}

		void MsgTick() {
			GameDialog::MsgTick();

			if (::key[KEY_ENTER] || ::key[KEY_SPACE] || mouse_b) {
				Close();
			}

			static char *line1[] = {
				"                                       ______                                 ",
				" /'\\_/`\\  __                          /\\  _  \\                                ",
				"/\\      \\/\\_\\  _ __    __      ___    \\ \\ \\L\\ \\    ___ ___     ___     ___    ",
				"\\ \\ \\__\\ \\/\\ \\/\\`'__\\/'__`\\  /' _ `\\   \\ \\  __ \\ /' __` __`\\  / __`\\ /' _ `\\  ",
				" \\ \\ \\_/\\ \\ \\ \\ \\ \\//\\ \\L\\.\\_/\\ \\/\\ \\   \\ \\ \\/\\ \\/\\ \\/\\ \\/\\ \\/\\ \\L\\ \\/\\ \\/\\ \\ ",
				"  \\ \\_\\\\ \\_\\ \\_\\ \\_\\\\ \\__/.\\_\\ \\_\\ \\_\\   \\ \\_\\ \\_\\ \\_\\ \\_\\ \\_\\ \\____/\\ \\_\\ \\_\\",
				"   \\/_/ \\/_/\\/_/\\/_/ \\/__/\\/_/\\/_/\\/_/    \\/_/\\/_/\\/_/\\/_/\\/_/\\/___/  \\/_/\\/_/",
				"",
				"",
				"",
				"",
				"",
				"                                                  __             ",
				"                                                 /\\ \\__          ",
				"         _____   _ __    __    ____     __    ___\\ \\ ,_\\   ____  ",
				"        /\\ '__`\\/\\`'__\\/'__`\\ /',__\\  /'__`\\/' _ `\\ \\ \\/  /',__\\ ",
				"        \\ \\ \\L\\ \\ \\ \\//\\  __//\\__, `\\/\\  __//\\ \\/\\ \\ \\ \\_/\\__, `\\",
				"         \\ \\ ,__/\\ \\_\\\\ \\____\\/\\____/\\ \\____\\ \\_\\ \\_\\ \\__\\/\\____/",
				"          \\ \\ \\/  \\/_/ \\/____/\\/___/  \\/____/\\/_/\\/_/\\/__/\\/___/ ",
				"           \\ \\_\\                                                 ",
				"            \\/_/                                                 ",
				0
			};

			static char *line2[] = {
				"                 ______  ______   __  __  ____           __     ____    ",
				"                /\\__  _\\/\\__  _\\ /\\ \\/\\ \\/\\  _`\\       /'__`\\  /'___\\   ",
				"         __     \\/_/\\ \\/\\/_/\\ \\/ \\ \\ `\\\\ \\ \\,\\L\\_\\    /\\ \\/\\ \\/\\ \\__/   ",
				"       /'__`\\      \\ \\ \\   \\ \\ \\  \\ \\ , ` \\/_\\__ \\    \\ \\ \\ \\ \\ \\  _``\\ ",
				"      /\\ \\L\\.\\_     \\ \\ \\   \\_\\ \\__\\ \\ \\`\\ \\/\\ \\L\\ \\   \\ \\ \\_\\ \\ \\ \\L\\ \\",
				"      \\ \\__/.\\_\\     \\ \\_\\  /\\_____\\\\ \\_\\ \\_\\ `\\____\\   \\ \\____/\\ \\____/",
				"       \\/__/\\/_/      \\/_/  \\/_____/ \\/_/\\/_/\\/_____/    \\/___/  \\/___/ ",
				"",
				"",
				"",
				"",
				"",
				"                            __                  __                           ",
				"                           /\\ \\                /\\ \\__  __                    ",
				"     _____   _ __   ___    \\_\\ \\  __  __    ___\\ \\ ,_\\/\\_\\    ___     ___    ",
				"    /\\ '__`\\/\\`'__\\/ __`\\  /'_` \\/\\ \\/\\ \\  /'___\\ \\ \\/\\/\\ \\  / __`\\ /' _ `\\  ",
				"    \\ \\ \\L\\ \\ \\ \\//\\ \\L\\ \\/\\ \\L\\ \\ \\ \\_\\ \\/\\ \\__/\\ \\ \\_\\ \\ \\/\\ \\L\\ \\/\\ \\/\\ \\ ",
				"     \\ \\ ,__/\\ \\_\\\\ \\____/\\ \\___,_\\ \\____/\\ \\____\\\\ \\__\\\\ \\_\\ \\____/\\ \\_\\ \\_\\",
				"      \\ \\ \\/  \\/_/ \\/___/  \\/__,_ /\\/___/  \\/____/ \\/__/ \\/_/\\/___/  \\/_/\\/_/",
				"       \\ \\_\\                                                                 ",
				"        \\/_/                                                                 ",
				0
			};

			static char *line3[] = {
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"             ____                __                          ",
				"            /\\  _`\\             /\\ \\                         ",
				"            \\ \\ \\/\\ \\    ___    \\_\\ \\     __      __   _ __  ",
				"             \\ \\ \\ \\ \\  / __`\\  /'_` \\  /'_ `\\  /'__`\\/\\`'__\\",
				"              \\ \\ \\_\\ \\/\\ \\L\\ \\/\\ \\L\\ \\/\\ \\L\\ \\/\\  __/\\ \\ \\/ ",
				"               \\ \\____/\\ \\____/\\ \\___,_\\ \\____ \\ \\____\\\\ \\_\\ ",
				"                \\/___/  \\/___/  \\/__,_ /\\/___L\\ \\/____/ \\/_/ ",
				"                                          /\\____/            ",
				"                                          \\_/__/             ",
				0
			};

			static char *empty[] = {
				0
			};

			char **text = 0;

			++counter;
			switch (counter) {
				case 1:		text = line1;	break;
				case 200:	text = empty;	break;
				case 250:	text = line2;	break;
				case 450:	text = empty;	break;
				case 500:	text = line3;	break;
			};

			if (counter >= 500) {
				if ((counter/25)%2) {
					text = empty;
				}
				else {
					text = line3;
				}
			}

			if (text) {
				int i=0;
				while (text[i]) {
					lbl[i].SetText(text[i]);
					++i;
				}
				for (; i<32; i++) {
					lbl[i].SetText("");
				}
			}

			if (counter >= 1000) {
				Close();
			}
		}

		void MsgEnd() {
			GameDialog::MsgEnd();
			play_music(1);
		}
};
*/

class IntroScreen : public GameDialog {
	private:
		Background desktop;
		int counter;

		TextButton lbl[3];

	public:
		IntroScreen() : GameDialog() {
			Add(desktop);

			int dy = 8;
			int x = 0;
			int w = 100;
			int y = 40-dy;
			int h = dy;

			for (int i=0; i<3; i++) {
				lbl[i].Shape(x, y+=dy, w, h, 1);
				lbl[i].Disable();
				lbl[i].AlignCentre();
				Add(lbl[i]);
			}

			Add(anim);
		}

		int Run() {
			counter = 0;
			play_music(0);
			MAS::Settings::showMouse = false;
			Widget *obj = Execute();
			MAS::Settings::showMouse = true;
			return S_MAIN_MENU;
		}

		void MsgTick() {
			GameDialog::MsgTick();

			if (::key[KEY_ENTER] || ::key[KEY_SPACE] || mouse_b) {
				Close();
			}

			static const char *line1[] = {
				lng.GetString(STR_INTRO1).c_str(),
				" ",
				lng.GetString(STR_INTRO2).c_str()
			};

			static const char *line2[] = {
				lng.GetString(STR_INTRO3).c_str(),
				" ",
				lng.GetString(STR_INTRO4).c_str()
			};

			static const char *line3[] = {
				" ",
				lng.GetString(STR_INTRO5).c_str(),
				" "
			};

			static const char *empty[] = {
				" ",
				" ",
				" "
			};

			const char **text = 0;

			++counter;
			switch (counter) {
				case 1:		text = line1;	break;
				case 200:	text = empty;	break;
				case 250:	text = line2;	break;
				case 450:	text = empty;	break;
				case 500:	text = line3;	break;
			};

			if (counter >= 500) {
				if ((counter/25)%2) {
					text = empty;
				}
				else {
					text = line3;
				}
			}

			if (text) {
				for (int i=0; i<3; i++) {
					lbl[i].SetText(text[i]);
				}
			}

			if (counter >= 1000) {
				Close();
			}
		}

		void MsgEnd() {
			GameDialog::MsgEnd();
			play_music(1);
		}
};


class OutroScreen : public GameDialog {
	private:
		Background desktop;
		TextButton lbl[2];
		int counter;

	public:
		OutroScreen() : GameDialog() {
			Add(desktop);

			int dy = 16;
			int y = 40-dy;
			int h = 10;
			int x = 0;
			int w = 100;

			for (int i=0; i<2; i++) {
				y += dy;

				lbl[i].Shape(x, y, w, h, 1);
				lbl[i].Disable();
				lbl[i].AlignCentre();
				Add(lbl[i]);
			}

			Add(anim);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();

			const char *lblText[] = {
				lng.GetString(STR_OUTRO1).c_str(),
				lng.GetString(STR_OUTRO2).c_str()
			};

			for (int i=0; i<2; i++) {
				lbl[i].SetText(lblText[i]);
			}
		}

		int Run() {
			counter = 0;
			Widget *obj = Execute();
			return S_EXIT_GAME;
		}

		void MsgTick() {
			GameDialog::MsgTick();

			if (::key[KEY_ENTER] || ::key[KEY_SPACE] || mouse_b) {
				Close();
			}

			++counter;
			if (counter >= 300) {
				Close();
			}
		}
};


int on_theme(const char *path, int attrib, void *param) {
	attrib = 0;
	ChoiceButton *btn = (ChoiceButton *)param;

	static char buf[256];
	ustrcpy(buf, path);
	char *filename = get_filename(buf);
	if (filename[0] == '.') {
		return 0;
	}
	btn->choice.push_back(filename);

	return 0;
}


class DialogGfx : public GameDialog {
	private:
		Background desktop;
		TextButton lbl[5];
		ChoiceButton btn[5];
		TextButton bBack;

	public:
		DialogGfx() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			int dy = 10;
			int y = 24 - dy + dy/2;
			int h = 10;
			int x = 0;
			int w = 100;

			for (int i=0; i<5; i++) {
				y += dy;

				lbl[i].Shape(x, y, 3*w/5, h, 1);
				lbl[i].Disable();
				lbl[i].AlignRight();
				Add(lbl[i]);

				btn[i].Shape(3*w/5+4, y, w/3 - 4, h, 1);
				btn[i].AlignLeft();
				Add(btn[i]);
			}

			for (int i=0; i<4; i++) {
				btn[i].choice.push_back("-");
				btn[i].choice.push_back("-");
			}

			btn[0].selection = Settings::fullscreen ? 1 : 0;
			btn[1].selection = Settings::showFrameRate ? 1 : 0;
			btn[2].selection = Settings::vsync ? 1 : 0;
			btn[3].selection = shadows ? 1 : 0;

			y += dy/2;
			bBack.Shape(x, y+=dy, w, h, 1);
			bBack.MakeExit();
			bBack.AlignCentre();
			Add(bBack);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();

			const char *lblText[] = {
				lng.GetString(STR_GFX_FULLSCREEN).c_str(),
				lng.GetString(STR_GFX_FRAMERATE).c_str(),
				lng.GetString(STR_GFX_VSYNC).c_str(),
				lng.GetString(STR_GFX_SHADOWS).c_str(),
				lng.GetString(STR_GFX_THEME).c_str()
			};

			for (int i=0; i<5; i++) {
				lbl[i].SetText(lblText[i]);
			}

			for (int i=0; i<4; i++) {
				btn[i].choice[0] = lng.GetString(STR_NO).c_str();
				btn[i].choice[1] = lng.GetString(STR_YES).c_str();
			}

			// find available themes
			char full[256];
			MakeFullPath(full, "themes/*");
			btn[4].choice.clear();
			for_each_file_ex(full, FA_DIREC, 0, on_theme, &(btn[4]));
			std::sort(btn[4].choice.begin(), btn[4].choice.end());

			// find selected theme
			std::string sel_thm = std::string(theme_name);
			btn[4].selection = 0;
			for (int i=0; i<btn[4].choice.size(); i++) {
				if (btn[4].choice[i] == sel_thm) {
					btn[4].selection = i;
					break;
				}
			}

			bBack.SetText(lng.GetString(STR_BACK).c_str());
		}

		int Run() {
			Widget *obj = Execute(&btn[0]);
			return S_OPTIONS;
		}

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			GameDialog::HandleEvent(obj, msg, arg1, arg2);

			if (msg == MSG_ACTIVATE) {
				ChoiceButton *tmp = 0;
				int index = -1;

				for (int i=0; i<5; i++) {
					if (obj == btn[i]) {
						tmp = (ChoiceButton *)&obj;
						index = i;
						break;
					}
				}

				if (tmp) {
					if (arg1 == arg2 && arg1 == 0) {
						tmp->Increment();
					}

					switch (index) {
						case 0:		Settings::fullscreen = tmp->selection;
									ChangeResolution(Settings::gfxMode, Settings::fullscreen, Settings::screenWidth, Settings::screenHeight, Settings::colorDepth, Root());
									theme.Load(theme_name, Root());
									play_music(1);
						break;
						case 1:		Settings::showFrameRate = tmp->selection;	break;
						case 2:		Settings::vsync = tmp->selection;			break;
						case 3:		shadows = tmp->selection;					break;
						case 4:		theme.Load(btn[4].choice[btn[4].selection].c_str(), Root());
									play_music(1);
						break;
					};
				}
			}
		}
};


class DialogSound : public GameDialog {
	private:
		Background desktop;
		TextButton lbl[2];
		ChoiceButton btn[2];
		TextButton bBack;

	public:
		DialogSound() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			int dy = 10;
			int y = 24 - dy + 2*dy;
			int h = 10;
			int x = 0;
			int w = 100;

			for (int i=0; i<2; i++) {
				y += dy;

				lbl[i].Shape(x, y, w/2, h, 1);
				lbl[i].Disable();
				lbl[i].AlignRight();
				Add(lbl[i]);

				btn[i].Shape(w/2+4, y, w/3 - 4, h, 1);
				btn[i].AlignLeft();
				Add(btn[i]);
			}

			for (int i=0; i<2; i++) {
				btn[i].choice.push_back("-");
				btn[i].choice.push_back("10%%");
				btn[i].choice.push_back("20%%");
				btn[i].choice.push_back("30%%");
				btn[i].choice.push_back("40%%");
				btn[i].choice.push_back("50%%");
				btn[i].choice.push_back("60%%");
				btn[i].choice.push_back("70%%");
				btn[i].choice.push_back("80%%");
				btn[i].choice.push_back("90%%");
				btn[i].choice.push_back("100%%");
			}

			btn[0].selection = soundVolume;
			btn[1].selection = musicVolume;

			y += 2*dy;
			bBack.Shape(x, y+=dy, w, h, 1);
			bBack.MakeExit();
			bBack.AlignCentre();
			Add(bBack);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();

			const char *lblText[] = {
				lng.GetString(STR_SND_SOUND).c_str(),
				lng.GetString(STR_SND_MUSIC).c_str()
			};

			for (int i=0; i<2; i++) {
				lbl[i].SetText(lblText[i]);
			}

			for (int i=0; i<2; i++) {
				btn[i].choice[0] = lng.GetString(STR_OFF).c_str();
			}

			bBack.SetText(lng.GetString(STR_BACK).c_str());
		}

		int Run() {
			Widget *obj = Execute(&btn[0]);
			return S_OPTIONS;
		}

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			GameDialog::HandleEvent(obj, msg, arg1, arg2);

			if (msg == MSG_ACTIVATE) {
				ChoiceButton *tmp = 0;
				int index = -1;

				for (int i=0; i<2; i++) {
					if (obj == btn[i]) {
						tmp = (ChoiceButton *)&obj;
						index = i;
						break;
					}
				}

				if (tmp) {
					if (arg1 == arg2 && arg1 == 0) {
						tmp->Increment();
					}

					switch (index) {
						case 0:		soundVolume = tmp->selection;
									Settings::soundVolume = soundVolume*25;
						break;
						case 1:		musicVolume = tmp->selection;				break;
					};
				}
			}
		}
};


int on_language(const char *path, int attrib, void *param) {
	attrib = 0;
	ChoiceButton *btn = (ChoiceButton *)param;

	static char buf[256];
	ustrcpy(buf, path);
	char *filename = get_filename(buf);
	char *ext = get_extension(filename) - 1;
	ext[0] = 0;
	btn->choice.push_back(filename);

	return 0;
}


class DialogSettings : public GameDialog {
	private:
		Background desktop;
		TextButton lbl[2];
		ChoiceButton btn[2];
		TextButton btn2[2];
		TextButton bBack;

	public:
		DialogSettings() : GameDialog() {
			desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
			Add(desktop);

			int dy = 10;
			int y = 24-dy + dy;
			int h = 10;
			int x = 0;
			int w = 100;

			for (int i=0; i<2; i++) {
				y += dy;

				btn2[i].Shape(x, y, w, h, 1);
				btn2[i].MakeExit();
				btn2[i].AlignCentre();
				Add(btn2[i]);
			}

			for (int i=0; i<2; i++) {
				y += dy;

				lbl[i].Shape(x, y, 3*w/5, h, 1);
				lbl[i].Disable();
				lbl[i].AlignRight();
				Add(lbl[i]);

				btn[i].Shape(3*w/5+4, y, w/3 - 4, h, 1);
				btn[i].AlignLeft();
				Add(btn[i]);
			}

			btn[0].choice.push_back("-");
			btn[0].choice.push_back("25%%");
			btn[0].choice.push_back("50%%");
			btn[0].choice.push_back("75%%");
			btn[0].choice.push_back("90%%");

			switch (Settings::gfxFrameRate) {
				case  10:	btn[0].selection = 4;		break;
				case  25:	btn[0].selection = 3;		break;
				case  50:	btn[0].selection = 2;		break;
				case  75:	btn[0].selection = 1;		break;
				case 100:	btn[0].selection = 0;		break;
			}

			y += dy;
			bBack.Shape(x, y+=dy, w, h, 1);
			bBack.MakeExit();
			bBack.AlignCentre();
			Add(bBack);

			Add(globalWidgets->title);
			Add(globalWidgets->lblBottom);
			Add(anim);
		}

		void SetLanguage() {
			GameDialog::SetLanguage();

			const char *lblText[] = {
				lng.GetString(STR_SETTINGS_GFX).c_str(),
				lng.GetString(STR_SETTINGS_SOUND).c_str(),
				lng.GetString(STR_SETTINGS_CPU).c_str(),
				lng.GetString(STR_SETTINGS_LANGUAGE).c_str()
			};

			for (int i=0; i<2; i++) {
				btn2[i].SetText(lblText[i]);
				lbl[i].SetText(lblText[i+2]);
			}

			// find available languages
			char full[256];
			MakeFullPath(full, "language/*.lng");
			btn[1].choice.clear();
			for_each_file_ex(full, 0, 0, on_language, &(btn[1]));
			std::sort(btn[1].choice.begin(), btn[1].choice.end());

			// find selected language
			std::string sel_lng = std::string(lng_filename);
			btn[1].selection = 0;
			for (int i=0; i<btn[1].choice.size(); i++) {
				if (btn[1].choice[i] == sel_lng) {
					btn[1].selection = i;
					break;
				}
			}

			btn[0].choice[0] = lng.GetString(STR_OFF).c_str();
			bBack.SetText(lng.GetString(STR_BACK).c_str());
		}

		int Run() {
			Widget *obj = Execute(&btn2[0]);
			if (obj == &btn2[0]) {
				return S_GFX;
			}
			else if (obj == &btn2[1]) {
				return S_SOUND;
			}

			return S_MAIN_MENU;
		}

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			GameDialog::HandleEvent(obj, msg, arg1, arg2);

			if (msg == MSG_ACTIVATE) {
				ChoiceButton *tmp = 0;
				int index = -1;

				for (int i=0; i<2; i++) {
					if (obj == btn[i]) {
						tmp = (ChoiceButton *)&obj;
						index = i;
						break;
					}
				}

				if (tmp) {
					if (arg1 == arg2 && arg1 == 0) {
						tmp->Increment();
					}

					switch (index) {
						case 0:
							Settings::yield = true;
							Settings::unlimitedFrameRate = false;
							if (tmp->selection == 0) {
								Settings::gfxFrameRate = 100;
								Settings::yield = false;
								Settings::unlimitedFrameRate = true;
							} else
							if (tmp->selection == 1) {
								Settings::gfxFrameRate = 75;
							} else
							if (tmp->selection == 2) {
								Settings::gfxFrameRate = 50;
							} else
							if (tmp->selection == 3) {
								Settings::gfxFrameRate = 25;
							} else
							if (tmp->selection == 4) {
								Settings::gfxFrameRate = 10;
							}
						break;
						case 1: {
							char full[256];
							char lng_name[256];
							ustrcpy(lng_filename, btn[1].choice[btn[1].selection].c_str());
							usprintf(lng_name, "language/%s.lng", lng_filename);
							MakeFullPath(full, lng_name);
							LoadLanguage(full);
						}
						break;
					};
				}
			}
		}
};

//------------------------------------------------------------------------------------

// Now comes the core of our simple game menu system. The system is a finite state
// machine. It has a number of states where each has a dialog attached (except for
// the exit state). At all times the control is at exactly one of the states. For
// every iteration through the FSM the current state is evaluated and control is
// passed to the next state as indicated by the current state's return value.

void GameFramework() {
	// make all our states (dialogs)
	dlg[S_INTRO] = new IntroScreen;
	dlg[S_MAIN_MENU] = new MainMenu;
	dlg[S_OPTIONS] = new DialogSettings;
	dlg[S_GFX] = new DialogGfx;
	dlg[S_SOUND] = new DialogSound;
	dlg[S_HIGHSCORES] = new DialogHSC;
	dlg[S_ABOUT] = new DialogAbout;
	dlg[S_PLAYING] = new MainGameDialog;
	dlg[S_OUTRO] = new OutroScreen;
	dlg[S_REPLAY] = new ReplayDialog;

	char full[256];
	char lng_name[256];
	usprintf(lng_name, "language/%s.lng", lng_filename);
	MakeFullPath(full, lng_name);
	LoadLanguage(full);

	// give control to the entry point (the main menu)
	GameDialog *currentDialog = dlg[S_INTRO];

	// do the state machine in an endless loop
	while (true) {
		// evaluate the current state and see what it wants
DEBUG
		int nextState = currentDialog->Run();
DEBUG

		// if the next state is the exit state, break from the loop
		if (nextState == S_EXIT_GAME) {
DEBUG
			break;
		}
		// otherwise pass the control to the next state
		else {
DEBUG
			currentDialog = dlg[nextState];
DEBUG
		}
	}

	// clean up when we're done
DEBUG
	for (int i=0; i<S_COUNT; i++) {
DEBUG
		delete dlg[i];
	}
DEBUG
}


// the standard MASkinG main function
int main() {
	allegro_init();
	char full[1024];
	MakeFullPath(full, "allegro.cfg");
	push_config_state();
	set_config_file(full);
	set_config_int("MASkinG", "logicFrameRate", 100);
	pop_config_state();

	Error err = InstallMASkinG("allegro.cfg");
	if (err) {
		err.Report();
	}

	mysrand(time(0));

	atexit(&dumb_exit);
	dumb_register_stdfiles();

	curl = curl_easy_init();

DEBUG
	fps.Init(MAS::Settings::logicFrameRate);
	//fps.Init(MAS::Settings::gfxFrameRate);
	globalWidgets = new GlobalWidgets;
	InitData();
	//LoadData();

DEBUG
	push_config_state();
	MakeFullPath(full, "allegro.cfg");
	set_config_file(full);
	soundVolume = get_config_int("Dodger", "soundVolume", soundVolume);
	musicVolume = get_config_int("Dodger", "musicVolume", musicVolume);
	ustrcpy(hsc_url, get_config_string("Dodger", "hscurl", "localhost"));
	ustrcpy(lng_filename, get_config_string("Dodger", "language", "english"));
	ustrcpy(theme_name, get_config_string("Dodger", "theme", "dodger"));
	shadows = get_config_int("Dodger", "shadows", 1) == 0 ? false : true;
	Settings::soundVolume = soundVolume*25;
	pop_config_state();

	theme.Load(theme_name);

	/* sin/cos look up tables */
	int c;
	for (c=0; c<LUT_SIZE; c++) {
		SIN[c] = sin(c*M_PI/128.0);
		COS[c] = cos(c*M_PI/128.0);
	}
	SIN[c] = sin(c*M_PI/128.0);
	COS[c] = cos(c*M_PI/128.0);

	MakeFullPath(full, "dodger_online.hsc");
	hsc = new HSC;
	hsc->Load(full);
	DownloadHSC();

	MakeFullPath(full, "dodger.hsc");
	local_hsc = new HSC;
	local_hsc->Load(full);

DEBUG
	GameFramework();
DEBUG
	UnloadData();

	KillThreads();
DEBUG
	delete globalWidgets;

	MakeFullPath(full, "dodger_online.hsc");
	hsc->Save(full);
	delete hsc;

	MakeFullPath(full, "dodger.hsc");
	local_hsc->Save(full);
	delete local_hsc;

DEBUG
	flush_config_file();

DEBUG
	push_config_state();
	MakeFullPath(full, "allegro.cfg");
	set_config_file(full);
	set_config_int("Dodger", "soundVolume", soundVolume);
	set_config_int("Dodger", "musicVolume", musicVolume);
	set_config_string("Dodger", "language", lng_filename);
	set_config_string("Dodger", "theme", theme_name);
	set_config_int("Dodger", "shadows", shadows ? 1 : 0);
	pop_config_state();

DEBUG
	flush_config_file();

DEBUG
	ExitMASkinG();
DEBUG
	curl_easy_cleanup(curl);

	return 0;
}
END_OF_MAIN();
