#include <math.h>
#include "drone.h"
#include "global.h"
#include "music_player.h"

int Drone::max_light_counter = 100;

Drone::Drone() : Object() {
	sprite_index = 0;
	radius = 32;
}


Drone::~Drone() {
}

void Drone::Init() {
	Object::Init();
	light_counter = myrand() % max_light_counter;
	speed = 0.8;
	angle = myrand()%256 * 2*M_PI/256.0;
}


void Drone::Update() {
	//Object::Update();

	++light_counter;
	light_counter %= max_light_counter;

	float vx = speed * cos(angle);
	float vy = speed * sin(angle);

	angle += 0.008;
	speed += 0.001;
	speed = MIN(speed, 3);

	float old_x = pos.x;
	float old_y = pos.y;

	pos.x += vx;
	pos.y += vy;

	bool hit_wall = false;

	if (pos.x < min.x || pos.x > max.x) {
		vx = -vx;
		hit_wall = true;
	}

	if (pos.y < min.y || pos.y > max.y) {
		vy = -vy;
		hit_wall = true;
	}

	if (hit_wall) {
		pos.x = old_x;
		pos.y = old_y;
		angle = atan2(vy, vx);
		//play_sound(cling_sample, 255, 128, -100, 0);
		play_2d_sound(cling_sample, 255, -100, (int)pos.x, (int)pos.y, 240, 240);
	}

	while (angle > 2*M_PI) {
		angle -= 2*M_PI;
	}

	//dir = itofix(fixtoi(dir) + 1);
}


void Drone::Draw(BITMAP *canvas) {
	BITMAP *spr = 0;
	BITMAP *shd = 0;
	int sprite_index = this->sprite_index;

	if (light_counter > max_light_counter/2) {
		++sprite_index;
	}

	spr = drone_sprite[sprite_index];
	shd = drone_sprite_shd[sprite_index];

	set_alpha_blender();
	if (MAS::Settings::colorDepth == 32 && shadows) {
		draw_trans_sprite(canvas, shd, (int)pos.x - spr->w/2 + 6, (int)pos.y - spr->h/2 + 4);
	}
	draw_trans_sprite(canvas, spr, (int)pos.x - spr->w/2, (int)pos.y - spr->h/2);
	//pivot_sprite(canvas, spr, (int)pos.x, (int)pos.y, spr->w/2, spr->h/2, dir);
}
