#include "theme.h"
#include "global.h"
using namespace MAS;

Theme::Theme() {
}


Theme::~Theme() {
}


void Theme::Load(const char *name, MAS::Dialog *root) {
	char full[1024];
	char buf[1024];

	// get absolute path
	usprintf(buf, "themes/%s/skin.ini", name);
	MakeFullPath(full, buf);

	// load the skin
	theSkin->Load(full);

	// load colours
	push_config_state();
	set_config_file(full);

	char section[] = "dodger";
	hsc_list_col = MAS::Color(get_config_string(section, "hsc_list_col", "0,0,0"));
	hsc_list_shd = MAS::Color(get_config_string(section, "hsc_list_shd", "0,0,0"));
	hsc_header_col = MAS::Color(get_config_string(section, "hsc_header_col", "0,0,0"));
	hsc_header_shd = MAS::Color(get_config_string(section, "hsc_header_shd", "0,0,0"));

	rpl_list_col = MAS::Color(get_config_string(section, "rpl_list_col", "0,0,0"));
	rpl_list_shd = MAS::Color(get_config_string(section, "rpl_list_shd", "0,0,0"));
	rpl_header_col = MAS::Color(get_config_string(section, "rpl_header_col", "0,0,0"));
	rpl_header_shd = MAS::Color(get_config_string(section, "rpl_header_shd", "0,0,0"));

	text_button_shd = MAS::Color(get_config_string(section, "text_button_shd", "0,0,0"));

	scroll_text_fg = MAS::Color(get_config_string(section, "scroll_text_fg", "0,0,0"));
	scroll_text_bg = MAS::Color(get_config_string(section, "scroll_text_bg", "0,0,0"));

	title_bg = MAS::Color(get_config_string(section, "title_bg", "0,0,0"));
	title_text = MAS::Color(get_config_string(section, "title_text", "0,0,0"));
	title_halo = MAS::Color(get_config_string(section, "title_halo", "0,0,0"));
	title_lines = MAS::Color(get_config_string(section, "title_lines", "0,0,0"));

	fps_fg = MAS::Color(get_config_string(section, "fps_fg", "0,0,0"));
	fps_bg = MAS::Color(get_config_string(section, "fps_bg", "0,0,0"));

	back_top = MAS::Color(get_config_string(section, "back_top", "0,0,0"));
	back_bottom = MAS::Color(get_config_string(section, "back_bottom", "0,0,0"));

	version_fg = MAS::Color(get_config_string(section, "version_fg", "0,0,0"));
	version_bg = MAS::Color(get_config_string(section, "version_bg", "0,0,0"));

	transition_bg = MAS::Color(get_config_string(section, "transition_bg", "0,0,0"));

	list_item_odd = MAS::Color(get_config_string(section, "list_item_odd", "0,0,0"));
	list_item_even = MAS::Color(get_config_string(section, "list_item_even", "0,0,0"));
	list_item_sel = MAS::Color(get_config_string(section, "list_item_sel", "0,0,0"));
	list_item_border = MAS::Color(get_config_string(section, "list_item_border", "0,0,0"));

	help_fg = MAS::Color(get_config_string(section, "help_fg", "0,0,0"));
	help_bg = MAS::Color(get_config_string(section, "help_bg", "0,0,0"));

	expl_offset_r = get_config_int(section, "expl_offset_r", 0);
	expl_offset_g = get_config_int(section, "expl_offset_g", 0);
	expl_offset_b = get_config_int(section, "expl_offset_b", 0);
	expl_range_r = get_config_int(section, "expl_range_r", 1);
	expl_range_g = get_config_int(section, "expl_range_g", 1);
	expl_range_b = get_config_int(section, "expl_range_b", 1);
	if (expl_range_r == 0) expl_range_r = 1;
	if (expl_range_g == 0) expl_range_g = 1;
	if (expl_range_b == 0) expl_range_b = 1;

	pop_config_state();

	// attach the skin to the root dialog
	if (root) {
		//root->SetSkin(theSkin);
	}
	for (int i=0; i<S_COUNT; i++) {
		if (dlg[i]) {
			dlg[i]->SetSkin(theSkin);
		}
	}

	// load other data
	usprintf(buf, "themes/%s", name);
	MakeFullPath(full, buf);
	LoadData(full);

	ustrcpy(theme_name, name);
}
