#include "object.h"

Object::Object() : pos(0.0f, 0.0f), min(0.0f, 0.0f), max(1024.0f, 768.0f), v(0.0f, 0.0f), radius(1) {
}


Object::~Object() {
}


void Object::Update() {
	pos.x = MID(min.x, pos.x + v.x, max.x);
	pos.y = MID(min.y, pos.y + v.y, max.y);
}


bool Object::CollidesWith(Object *obj) {
	float max = (radius + obj->radius)*(radius + obj->radius);
	float dist = pos.Distance2(obj->pos);
	return dist < max;
}
