#include "global.h"
#include "hsc.h"
using namespace std;

#include <time.h>
#include <allegro.h>
#include <MASkinG.h>


HSC::Entry::Entry() {
	name = string("---");
	date = string("yyyy/mm/dd hh:mm");
	score = 0;

	time_t t;
	struct tm *ct;
	time(&t);
	ct = localtime(&t);
	char buf[256];
	usprintf(buf, "%04d/%02d/%02d %02d:%02d", ct->tm_year+1900, ct->tm_mon+1, ct->tm_mday, ct->tm_hour, ct->tm_min);
	date = string(buf);
}


HSC::HSC() {
}


void HSC::Load(std::string filename) {
DEBUG
	PACKFILE *f = pack_fopen(filename.c_str(), "r");

	if (f) {
		// HSCR
		char buf[256];
		pack_fread(buf, 4, f);

		if (ustrncmp("HSCR", buf, 4) == 0) {
			scores.clear();

			int count = 0;
			pack_fread(&count, sizeof(int), f);

			for (int i=0; i<count; i++) {
				Entry e;
				int size = 0;

				pack_fread(&size, sizeof(int), f);
				pack_fread(&buf, sizeof(char)*size, f);
				buf[size] = 0;
				e.name = string(buf);

				pack_fread(&size, sizeof(int), f);
				pack_fread(&buf, sizeof(char)*size, f);
				buf[size] = 0;
				e.date = string(buf);

				pack_fread(&e.score, sizeof(int), f);

				scores.push_back(e);
			}
		}

		pack_fclose(f);
	}
DEBUG
}


void HSC::Save(std::string filename) {
DEBUG
	PACKFILE *f = pack_fopen(filename.c_str(), "w");

	if (f) {
		int tmp = 0;
		pack_fwrite("HSCR", 4, f);
		tmp = Count();
		pack_fwrite(&tmp, sizeof(int), f);

		for (int i=0; i<Count(); i++) {
			Entry e = scores[i];

			tmp = e.name.size();
			pack_fwrite(&tmp, sizeof(int), f);
			pack_fwrite(e.name.c_str(), sizeof(char)*tmp, f);

			tmp = e.date.size();
			pack_fwrite(&tmp, sizeof(int), f);
			pack_fwrite(e.date.c_str(), sizeof(char)*tmp, f);

			tmp = e.score;
			pack_fwrite(&tmp, sizeof(int), f);
		}

		pack_fclose(f);
	}
DEBUG
}


int HSC::Count() {
DEBUG
	return scores.size();
}


HSC::Entry &HSC::GetEntry(int i) {
	if (i<0) i=0;
	if (i>=scores.size()) i = scores.size()-1;
DEBUG
	return scores[i];
}


void HSC::AddEntry(HSC::Entry e) {
	for (int i=0; i<Count(); i++) {
		if (scores[i].name == e.name && scores[i].date == e.date && scores[i].score == e.score) {
			return;
		}
	}

DEBUG
	if (Count() == entryLimit) {
		if (scores[entryLimit-1].score >= e.score) {
DEBUG
			return;
		}
	}

DEBUG
	if (scores.empty()) {
DEBUG
		scores.push_back(e);
	}
	else if (scores[0].score < e.score) {
DEBUG
		scores.insert(scores.begin(), e);
	}
	else {
DEBUG
		vector<Entry>::iterator i = scores.begin();
		for (; i != scores.end() && i->score >= e.score; ++i);
		scores.insert(i, e);
DEBUG
	}

DEBUG
	if (Count() > entryLimit) {
DEBUG
		scores.pop_back();
	}
DEBUG
}


bool HSC::CanAdd(int score) {
	// quick hack to prevent lamers from changing the logic frame rate
	if (MAS::Settings::logicFrameRate != 100) {
		return false;
	}

DEBUG
	if (score <= 0) {
DEBUG
		return false;
	}

	if (Count() < entryLimit) {
DEBUG
		return true;
	}

	if (score > scores.back().score) {
DEBUG
		return true;
	}

DEBUG
	return false;
}


void HSC::Reset() {
	scores.clear();
}


HSC::~HSC() {
}


bool HSC::HasTopScore(Entry &e) {
	for (int i=0; i<scores.size(); i++) {
		if (scores[i].name == e.name) {
			if (scores[i].score > e.score) {
				return false;
			}
			else {
				return true;
			}
		}
	}

	return true;
}
