#include "global.h"
#include "music_player.h"

GameDialog *dlg[S_COUNT];

BITMAP *back_tile = NULL;
BITMAP *tank_sprite[4][4];
BITMAP *rocket_sprite[4];
BITMAP *drone_sprite[8];
BITMAP *player_sprite[2];
BITMAP *drone_sprite_shd[8];
BITMAP *player_sprite_shd[2];

SAMPLE *cling_sample;
SAMPLE *shot_sample;
SAMPLE *explode_sample;

SCREENSHOT *screenshot;
CFPS fps;
HSC *hsc = 0;
HSC *local_hsc = 0;
char hsc_url[256];

bool shadows = true;

Language lng;
char lng_filename[256];

Theme theme;
char theme_name[256];

GlobalWidgets *globalWidgets = 0;

int soundVolume = 7;
int musicVolume = 7;

float SIN[LUT_SIZE+1];
float COS[LUT_SIZE+1];

/*
void TextButton::Draw(Bitmap &canvas) {
	FONT *f = HasFocus() || Selected() ? focusfont : normalfont;
	int offset = Selected() ? 2 : 0;

	switch (GetAlignment()) {
		case 0:
			textprintf_ex(canvas, f, 4+offset, -8+offset, theme.text_button_shd, -1, GetText());
			textprintf_ex(canvas, f, offset, -10+offset, -1, -1, GetText());
		break;

		case 1:
			textprintf_right_ex(canvas, f, w()+offset, -8+offset, theme.text_button_shd, -1, GetText());
			textprintf_right_ex(canvas, f, w()-4+offset, -10+offset, -1, -1, GetText());
		break;

		case 2:
			textprintf_centre_ex(canvas, f, w()/2+4+offset, -8+offset, theme.text_button_shd, -1, GetText());
			textprintf_centre_ex(canvas, f, w()/2+offset, -10+offset, -1, -1, GetText());
		break;
	};
}
*/

void TextButton::SetText(const char *text) {
	Button::SetText(text);

	for (int i=0; i<4; i++) {
		cache[i].Destroy();
	}
}


void TextButton::MsgInitSkin() {
	Button::MsgInitSkin();

	for (int i=0; i<4; i++) {
		SetFont(2, i);
		cache[i].Destroy();
	}
}


void OutlinePrint(Font &f, Bitmap &canvas, int x, int y, Color col, Color shd, int a, const char *text) {
	f.TextPrintf(canvas, Point(x-1,y), shd, -1, a, text);
	f.TextPrintf(canvas, Point(x+1,y), shd, -1, a, text);
	f.TextPrintf(canvas, Point(x,y-1), shd, -1, a, text);
	f.TextPrintf(canvas, Point(x,y+1), shd, -1, a, text);
	f.TextPrintf(canvas, Point(x+2,y+2), shd, -1, a, text);
	f.TextPrintf(canvas, Point(x,y), col, -1, a, text);
}


void TextButton::Draw(Bitmap &canvas) {
	// get the button state
	int state = Disabled() ? 2 : (Selected() ? 1 : (HasFocus() ? 3 : 0));

	if (!cache[state]) {
		cache[state].Create(w(), h());


		// Draw the button
		Bitmap bmp = GetBitmap();
		if (bmp) {
			if (TestFlag(D_AUTOSIZE)) {
				bmp.MaskedBlit(cache[state], 0, state*h(), 0, 0, w(), h());
			}
			else {
				bmp.MaskedTiledBlit(cache[state], 0, state, 0, 0, w(), h(), 1, 4);
			}
		}
		canvas.Blit(cache[state], Point(0, 0), Point(0, 0), cache[state].size());

		//MAS::Font f = GetFont(state);
		MAS::Font f = theSkin->GetFont(2);
		int offset = Selected() ? 2 : 0;

		int y = (h() - f.TextHeight())/2;
		int x = 0;
		int a = GetAlignment();

		switch (a) {
			case 0:		x = 0;		break;
			case 1:		x = w();	break;
			case 2:		x = w()/2;	break;
		};
		x += offset;

		Color col = GetFontColor(state);
		Color shd = GetShadowColor(state);

		OutlinePrint(f, cache[state], x, y, col, shd, a, GetText());
	}

	cache[state].Blit(canvas, Point(0, 0), Point(0, 0), cache[state].size());
}



ChoiceButton::ChoiceButton() : TextButton() {
	selection = -1;
}


char *ChoiceButton::GetText() {
	if (selection >= 0 && selection < choice.size()) {
		return (char *)choice[selection].c_str();
	}

	return "";
}


void ChoiceButton::Increment() {
	if (choice.size() == 2 || selection < choice.size()-1) {
		++selection;
		selection %= choice.size();
	}
}


void ChoiceButton::Decrement() {
	if (choice.size() == 2 || selection > 0) {
		--selection;
		if (selection < 0) {
			selection += choice.size();
		}
	}
}


bool ChoiceButton::MsgChar(int c) {
	if (TextButton::MsgChar(c)) {
		return true;
	}

	int old_sel = selection;

	switch (c>>8) {
		case KEY_LEFT:		Decrement();	break;
		case KEY_RIGHT:		Increment();	break;
		default:			return false;
	};

	if (selection != old_sel) {
		for (int i=0; i<4; i++) {
			cache[i].Destroy();
		}
		GetParent()->HandleEvent(*this, MSG_ACTIVATE, selection, old_sel);
		PlaySample(Skin::SAMPLE_ACTIVATE);
	}

	return true;
}

void ChoiceButton::MsgLPress() {
	Widget::MsgLPress();

	int old_sel = selection;
	Increment();
	if (selection != old_sel) {
		for (int i=0; i<4; i++) {
			cache[i].Destroy();
		}
		GetParent()->HandleEvent(*this, MSG_ACTIVATE, selection, old_sel);
		PlaySample(Skin::SAMPLE_ACTIVATE);
	}
}

void ChoiceButton::MsgRPress() {
	Widget::MsgRPress();
	int old_sel = selection;
	Decrement();
	if (selection != old_sel) {
		for (int i=0; i<4; i++) {
			cache[i].Destroy();
		}
		GetParent()->HandleEvent(*this, MSG_ACTIVATE, selection, old_sel);
		PlaySample(Skin::SAMPLE_ACTIVATE);
	}
}


ScrollingText::ScrollingText() : Label(), tick(0) {
}


void ScrollingText::Draw(Bitmap &canvas) {
	canvas.Clear(theme.scroll_text_bg);
	Font f = GetFont(0);
	const char *t = GetText();
	int l = f.TextLength(t);
	int dx = (tick)%l;
	f.TextPrintf(canvas, Point(-dx, 0), theme.scroll_text_fg, -1, 0, t);
	//textprintf_ex(canvas, f, -dx, 0, -1, -1, 0, t);

	if (-dx + l < w()) {
		f.TextPrintf(canvas, Point(-dx + l, 0), theme.scroll_text_fg, -1, 0, t);
	}
}


void ScrollingText::MsgTick() {
	Label::MsgTick();
	++tick;
}


void ScrollingText::LoadText(const char *filename) {
	PACKFILE *f = pack_fopen(filename, "r");
	char t[4096];
	pack_fgets(t, 4096, f);
	Label::SetText(t);
	pack_fclose(f);
}


void CustomLabel::MsgInitSkin() {
	Label::MsgInitSkin();

	SetFont(3, 0);
	cache.Destroy();
}


void CustomLabel::Draw(Bitmap &canvas) {
	if (!cache) {
		cache.Create(w(), h());
		cache.Clear(theme.title_bg);

		MAS::Font f = GetFont(0);

		int y = (h() - f.TextHeight())/2;
		int x = w()/2;

		Color col = theme.title_text;
		Color shd = theme.title_halo;

		f.TextPrintf(cache, Point(x-2,y), shd, -1, 2, GetText());
		f.TextPrintf(cache, Point(x+2,y), shd, -1, 2, GetText());
		f.TextPrintf(cache, Point(x,y-2), shd, -1, 2, GetText());
		f.TextPrintf(cache, Point(x,y+2), shd, -1, 2, GetText());
		//f.TextPrintf(cache, Point(x+4,y+4), shd, -1, 2, GetText());
		f.TextPrintf(cache, Point(x,y), col, -1, 2, GetText());

		col = theme.title_halo;
		hline(cache, 0, 0, w()-1, col);
		hline(cache, 0, h()-1, w()-1, col);

		col = theme.title_lines;
		hline(cache, 0, 1, w()-1, col);
		hline(cache, 0, h()-2, w()-1, col);
	}

	cache.Blit(canvas, Point(0,0), Point(0,0), cache.size());
}


/*
void CustomLabel::Draw(Bitmap &canvas) {
	canvas.Clear(theme.title_bg);

	Color col = theme.title_halo;
	textprintf_centre_ex(canvas, titlefont, w()/2+2, -16, col, -1, GetText());
	textprintf_centre_ex(canvas, titlefont, w()/2-2, -16, col, -1, GetText());
	textprintf_centre_ex(canvas, titlefont, w()/2, -14, col, -1, GetText());
	textprintf_centre_ex(canvas, titlefont, w()/2, -18, col, -1, GetText());
	//textprintf_centre_ex(canvas, titlefont, w()/2+4, -18, Color::black, -1, GetText());
	textprintf_centre_ex(canvas, titlefont, w()/2, -16, -1, -1, GetText());

	hline(canvas, 0, 0, w()-1, col);
	hline(canvas, 0, h()-1, w()-1, col);

	col = theme.title_lines;
	hline(canvas, 0, 1, w()-1, col);
	hline(canvas, 0, h()-2, w()-1, col);
}
*/


void Gradient(Bitmap &canvas, int x1, int y1, int x2, int y2, Color c1, Color c2) {
	float h2 = (float)(y2 - y1);

	float r1 = (float)c1.r();
	float g1 = (float)c1.g();
	float b1 = (float)c1.b();

	float r2 = (float)c2.r();
	float g2 = (float)c2.g();
	float b2 = (float)c2.b();

	float dr = (r2 - r1)/h2;
	float dg = (g2 - g1)/h2;
	float db = (b2 - b1)/h2;

	for (int i=y1; i<y2; i++) {
		hline(canvas, x1, i, x2, makecol((int)(r1+=dr), (int)(g1+=dg), (int)(b1+=db)));
	}
}


GameDialog::GameDialog() : Dialog() {
	acc.Add(KEY_F12, 0, 1000);
	acc.Add(KEY_PRTSCR, 0, 1000);
	Add(acc);
}


void GameDialog::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	if (msg == 1000) {
		take_screenshot(screenshot, GetDriver()->GetCanvas());
	}
}


void GameDialog::SetLanguage() {
	SetSkin(theSkin);
}


void GameDialog::MsgTick() {
	Dialog::MsgTick();
	fps.Tick();
	poll_music();
}


void GameDialog::MsgDraw() {
	Dialog::MsgDraw();
	fps.Frame();

	if (MAS::Settings::showFrameRate) {
		Bitmap canvas = Bitmap(GetDriver()->GetCanvas());
		skin->GetFont(1).TextPrintf(canvas, Point(0, 0), theme.fps_fg, theme.fps_bg, 0, "%d FPS", fps.Get());
	}
}



void Background::Draw(Bitmap &canvas) {
	Gradient(canvas, 0, 0, w()-1, h(), theme.back_top, theme.back_bottom);
	theSkin->GetFont(1).TextPrintf(canvas, SCREEN_W, SCREEN_H-15, theme.version_bg, -1, 1, lng.GetString(STR_ABOUT1).c_str(), DODGER_VERSION_MAJOR, DODGER_VERSION_MINOR);
	theSkin->GetFont(1).TextPrintf(canvas, SCREEN_W-1, SCREEN_H-16, theme.version_fg, -1, 1, lng.GetString(STR_ABOUT1).c_str(), DODGER_VERSION_MAJOR, DODGER_VERSION_MINOR);
}

void GameDialog::AnimWidget::MsgStart() {
	ClearScreen::MsgStart();
	startedAnimating = false;
}

void GameDialog::AnimWidget::MsgInitSkin() {
	ClearScreen::MsgInitSkin();
	//startedAnimating = false;
}



void GameDialog::AnimWidget::Draw(Bitmap &canvas) {
	if (!startedAnimating) {
		anim.Reset();
		//Bitmap canvas2 = Bitmap(GetParent()->GetDriver()->GetCanvas());
		//anim.Create(canvas2, 200);
		anim.Create(canvas, 200);
		startedAnimating = true;
	}

	if (anim.Animating()) {
		anim.Draw(canvas, Animator::CLOSE_HORIZONTAL);
	}
}


bool GameDialog::AnimWidget::MsgWantmouse() {
	return false;
}


void GameDialog::AnimWidget::MsgDraw() {

	ClearScreen::MsgDraw();
}


void GameDialog::AnimWidget::MsgTick() {
	ClearScreen::MsgTick();
	if (anim.Animating()) {
		anim.Update();
	}
}


void GameDialog::AnimWidget::Transition::Create(Bitmap &bmp, int length) {
	Animator::Create(bmp, length);
	back.Clear(theme.transition_bg);
}


void GameDialog::AnimWidget::Transition::Reset() {
	Animator::Reset();
	buffer.Destroy();
}


BITMAP *CreateShadow(BITMAP *src) {
	/*
	static int kernel_size = 7;
	static int kernel[][7] = {
		{ 1, 1, 1, 1, 1, 1, 1 },
		{ 1, 2, 2, 2, 2, 2, 1 },
		{ 1, 2, 4, 4, 4, 2, 1 },
		{ 1, 2, 4, 8, 4, 2, 1 },
		{ 1, 2, 4, 4, 4, 2, 1 },
		{ 1, 2, 2, 2, 2, 2, 1 },
		{ 1, 1, 1, 1, 1, 1, 1 }
	};
	*/
	/*
	static int kernel_size = 5;
	static int kernel[][5] = {
		{ 1, 2, 4, 2, 1 },
		{ 2, 4, 8, 4, 2 },
		{ 4, 8,16, 8, 4 },
		{ 2, 4, 8, 4, 2 },
		{ 1, 2, 4, 2, 1 }
	};
	*/
	static int kernel_size = 3;
	static int kernel[][3] = {
		{ 1, 2, 1 },
		{ 2, 4, 2 },
		{ 1, 2, 1 }
	};

	int amp = 0;
	for (int j=0; j<kernel_size; j++) {
		for (int i=0; i<kernel_size; i++) {
			amp += kernel[i][j];
		}
	}
	amp *= 2;

	int offset = (kernel_size-1)/2;
	BITMAP *bmp = create_bitmap(src->w+offset*2, src->h+offset*2);

	for (int y=0; y<bmp->h; y++) {
		for (int x=0; x<bmp->w; x++) {
			int a = 0;

			for (int j=0; j<kernel_size; j++) {
				for (int i=0; i<kernel_size; i++) {
					int xx = x - offset + i;
					int yy = y - offset + j;

					if (xx >= 0 && xx < src->w && yy >= 0 && yy < src->h) {
						int c = getpixel(src, xx, yy);
						a += geta(c) * kernel[i][j];
					}
				}
			}

			putpixel(bmp, x, y, makeacol(0,0,0,a/amp));
		}
	}

	return bmp;
}


Cursor *cur = 0;

void InitData() {
	back_tile = 0;

	for (int i=0; i<4; i++) {
		for (int j=0; j<4; j++) {
			tank_sprite[i][j] = 0;
		}
	}

	for (int i=0; i<4; i++) {
		rocket_sprite[i] = 0;
	}

	for (int i=0; i<8; i++) {
		drone_sprite[i] = 0;
		drone_sprite_shd[i] = 0;
	}

	for (int i=0; i<2; i++) {
		player_sprite[i] = 0;
		player_sprite_shd[i] = 0;
	}

	cling_sample = 0;
	shot_sample = 0;
	explode_sample = 0;

	music = 0;
}


void LoadData(const char *dir) {
	UnloadData();

	char full[1024];

DEBUG
	//TODO: load bitmaps, sounds, music, etc.
	usprintf(full, "%s/back.tga", dir);		back_tile = load_bitmap(full, 0);
	usprintf(full, "%s/tank1.tga", dir);	tank_sprite[0][0] = load_bitmap(full, 0);
	usprintf(full, "%s/tank2.tga", dir);	tank_sprite[0][1] = load_bitmap(full, 0);
	usprintf(full, "%s/tank3.tga", dir);	tank_sprite[0][2] = load_bitmap(full, 0);
	usprintf(full, "%s/tank4.tga", dir);	tank_sprite[0][3] = load_bitmap(full, 0);
	for (int j=0; j<4; j++) {
		BITMAP *src = tank_sprite[0][j];
		if (src) {
			BITMAP *s1 = create_bitmap(src->w, src->h);
			BITMAP *s2 = create_bitmap(src->w, src->h);
			BITMAP *s3 = create_bitmap(src->w, src->h);

			for (int y=0; y<src->h; y++) {
				for (int x=0; x<src->h; x++) {
					int c = getpixel(src, x, y);
					putpixel(s1, y, x, c);
					putpixel(s2, x, src->h-y-1, c);
					putpixel(s3, src->h-y-1, x, c);
				}
			}

			tank_sprite[1][j] = s1;
			tank_sprite[2][j] = s2;
			tank_sprite[3][j] = s3;
		}
	}
	usprintf(full, "%s/rocket.tga", dir);	rocket_sprite[0] = load_bitmap(full, 0);
	BITMAP *src = rocket_sprite[0];
	if (src) {
		BITMAP *s1 = create_bitmap(src->w, src->h);
		BITMAP *s2 = create_bitmap(src->w, src->h);
		BITMAP *s3 = create_bitmap(src->w, src->h);

		for (int y=0; y<src->h; y++) {
			for (int x=0; x<src->h; x++) {
				int c = getpixel(src, x, y);
				putpixel(s1, y, x, c);
				putpixel(s2, x, src->h-y-1, c);
				putpixel(s3, src->h-y-1, x, c);
			}
		}

		rocket_sprite[1] = s1;
		rocket_sprite[2] = s2;
		rocket_sprite[3] = s3;
	}
	usprintf(full, "%s/drone1a.tga", dir);	drone_sprite[0] = load_bitmap(full, 0);
	usprintf(full, "%s/drone1b.tga", dir);	drone_sprite[1] = load_bitmap(full, 0);
	usprintf(full, "%s/drone2a.tga", dir);	drone_sprite[2] = load_bitmap(full, 0);
	usprintf(full, "%s/drone2b.tga", dir);	drone_sprite[3] = load_bitmap(full, 0);
	usprintf(full, "%s/drone3a.tga", dir);	drone_sprite[4] = load_bitmap(full, 0);
	usprintf(full, "%s/drone3b.tga", dir);	drone_sprite[5] = load_bitmap(full, 0);
	usprintf(full, "%s/drone4a.tga", dir);	drone_sprite[6] = load_bitmap(full, 0);
	usprintf(full, "%s/drone4b.tga", dir);	drone_sprite[7] = load_bitmap(full, 0);
	usprintf(full, "%s/player1.tga", dir);	player_sprite[0] = load_bitmap(full, 0);
	usprintf(full, "%s/player2.tga", dir);	player_sprite[1] = load_bitmap(full, 0);

	for (int i=0; i<8; i++) {
		if (drone_sprite[i]) {
			drone_sprite_shd[i] = CreateShadow(drone_sprite[i]);
		}
	}
	for (int i=0; i<2; i++) {
		if (player_sprite[i]) {
			player_sprite_shd[i] = CreateShadow(player_sprite[i]);
		}
	}

	usprintf(full, "%s/cling.wav", dir);	cling_sample = load_sample(full);
	usprintf(full, "%s/shot.wav", dir);		shot_sample = load_sample(full);
	usprintf(full, "%s/explode.wav", dir);	explode_sample = load_sample(full);

DEBUG
/*
	cur = new Cursor;
	MakeFullPath(full, "data/cursor.tga");
	BITMAP *tmpCur = load_bitmap(full, NULL);
	cur->Create(tmpCur, 6);
	cur->SetFocus(0, 0);
	cur->SetAnimationInterval(100);
	theSkin->SetCursor(*cur, Skin::MOUSE_NORMAL);
	destroy_bitmap(tmpCur);
*/

	// make a title
	globalWidgets->title.Shape(0, 6, 100, 14, 1);
	globalWidgets->title.ClearFlag(D_AUTOSIZE);
	globalWidgets->title.AlignCentre();
	globalWidgets->title.SetText(lng.GetString(STR_GAMENAME_LARGE).c_str());

	// text scroller
	globalWidgets->lblBottom.Shape(0, SCREEN_H-24, SCREEN_W, 24);
	//MakeFullPath(full, "data/credits");
	//globalWidgets->lblBottom.LoadText(full);

	usprintf(full, "%s/music.it", dir);
	music = dumb_load_it(full);

	screenshot = create_screenshot("SHOT", "TGA");
DEBUG

	//TODO: check for errors
}

void UnloadData() {
DEBUG
	// TODO: destroy extra data
	if (back_tile) destroy_bitmap(back_tile);
DEBUG
	for (int i=0; i<4; i++) {
		for (int j=0; j<4; j++) {
			if (tank_sprite[i][j]) destroy_bitmap(tank_sprite[i][j]);
		}
DEBUG
		if (rocket_sprite[i]) destroy_bitmap(rocket_sprite[i]);
	}
DEBUG
	for (int i=0; i<8; i++) {
		if (drone_sprite[i]) destroy_bitmap(drone_sprite[i]);
		if (drone_sprite_shd[i]) destroy_bitmap(drone_sprite_shd[i]);
	}

	for (int i=0; i<2; i++) {
		if (player_sprite[i]) destroy_bitmap(player_sprite[i]);
		if (player_sprite_shd[i]) destroy_bitmap(player_sprite_shd[i]);
	}

	if (cling_sample) destroy_sample(cling_sample);
	if (shot_sample) destroy_sample(shot_sample);
	if (explode_sample) destroy_sample(explode_sample);

	if (music) {
		stop_music();
		unload_duh(music);
	}

	if (screenshot) destroy_screenshot(screenshot);

	InitData();
}


void HscItem::DrawBackground(Bitmap &dst, int state, const Rect &dstRect) {
	if (state == 1 || state == 5) {
		dst.Rectfill(dstRect, theme.list_item_sel);
		dst.Rectangle(dstRect.x(), dstRect.y(), dstRect.x2()-1, dstRect.y2()-1, theme.list_item_border);
	}
	else {
		dst.Rectfill(dstRect, odd ? theme.list_item_odd : theme.list_item_even);
	}
}


static unsigned long myrand_next = 0;

/* RAND_MAX assumed to be 32767 */
int myrand(void) {
	myrand_next = myrand_next * 0x343FD + 0x269EC3;
	return (myrand_next >> 0x10) & 0x7FFF;

	/*
	myrand_next = myrand_next * 1103515245 + 12345;
	return((unsigned)(myrand_next/65536) % 32768);
	*/
}

void mysrand(unsigned seed) {
	myrand_next = seed;
}


void LoadLanguage(const char *path) {
	lng.Load(path);

	globalWidgets->title.SetText(lng.GetString(STR_GAMENAME_LARGE).c_str());
	globalWidgets->lblBottom.SetText(lng.GetString(STR_CREDITS).c_str());
	set_window_title(lng.GetString(STR_GAMENAME_SMALL).c_str());

	for (int i=0; i<S_COUNT; i++) {
		dlg[i]->SetLanguage();
	}
}
