#include "gamedialog.h"


MainGameDialog::MainGameDialog() : GameDialog() {
	desktop.Shape(0, 0, SCREEN_W, SCREEN_H);
	desktop.timePanel = &timePanel;
	Add(desktop);

	timePanel.Shape(484, 376, 168, 96);
	Add(timePanel);

	hscPanel = new HscDialog;
	helpPanel = new HelpDialog;

	acc.Add(KEY_F1, 0, 2000);
	acc.Add(KEY_F2, 0, 2002);
	Add(acc);

	Add(anim);
	escapeExits = false;

	current_hsc = hsc;
	hsc_counter = 0;
}

MainGameDialog::~MainGameDialog() {
	/*
DEBUG
	if (hscPanel) {
		delete hscPanel;
		hscPanel = 0;
	}
DEBUG
	if (helpPanel) {
		delete helpPanel;
		helpPanel = 0;
	}
DEBUG
	*/
}

int MainGameDialog::Run() {
	// run the dialog and remember which object caused it to close
	ret = S_MAIN_MENU;
	desktop.StartPlaying();
	hscPanel->Shape(484+160, 8, 160, 356);
	helpPanel->Shape(484+160, 8, 160, 356);
	Add(*hscPanel);
	Add(*helpPanel);
	hscPanel->FillHscList(current_hsc);
	progress = 0;
	duration = 30;
	state = 5;
	//Settings::showMouse = false;
	hsc_counter = 6*Settings::logicFrameRate;
	Execute(&desktop);
	//Settings::showMouse = true;
	Remove(*hscPanel);
	Remove(*helpPanel);
	return ret;
}


void MainGameDialog::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	GameDialog::HandleEvent(obj, msg, arg1, arg2);

	if (msg == 2000) {
		switch (state) {
			case 0:
				state = 1;
				progress = 0;
			break;

			case 3:
				state = 4;
				progress = 0;
			break;
		};
	}
	else if (msg == 2001) {
		hscPanel->FillHscList(current_hsc);
	}
	else if (msg == 2002) {
		current_hsc = current_hsc == hsc ? local_hsc : hsc;
		hscPanel->FillHscList(current_hsc);
	}
	else if (msg == 2003 && obj == desktop) {
		ret = S_REPLAY;
		Close();
	}
	else if (msg == MSG_CLICK && obj.GetParent() == hscPanel) {
		current_hsc = current_hsc == hsc ? local_hsc : hsc;
		hscPanel->FillHscList(current_hsc);
	}
}


void MainGameDialog::MsgTick() {
	GameDialog::MsgTick();

	--hsc_counter;
	if (hsc_counter <= 0) {
		//current_hsc = current_hsc == hsc ? local_hsc : hsc;
		//hscPanel->FillHscList(current_hsc);
		hsc_counter = 600;
	}

	switch (state) {
		case 1: {
			++progress;
			hscPanel->x(484 + progress*160/duration);
			if (progress == duration) {
				state = 2;
				progress = 0;
			}
		}
		break;

		case 2: {
			++progress;
			helpPanel->x(484 + (duration - progress)*160/duration);
			if (progress == duration) {
				state = 3;
				progress = 0;
			}
		}
		break;

		case 4: {
			++progress;
			helpPanel->x(484 + progress*160/duration);
			if (progress == duration) {
				state = 5;
				progress = 0;
			}
		}
		break;

		case 5: {
			++progress;
			hscPanel->x(484 + (duration - progress)*160/duration);
			if (progress == duration) {
				state = 0;
				progress = 0;
			}
		}
		break;
	};
}


void MainGameDialog::SetLanguage() {
	hscPanel->panel.SetTooltipText(lng.GetString(STR_HELP_TOOLTIP).c_str());
	hscPanel->lblF1.SetText(lng.GetString(STR_HELP_INSTRUCTIONS).c_str());
	hscPanel->lstHsc.SetColumnTitle(0, lng.GetString(STR_HELP_NAME).c_str());
	hscPanel->lstHsc.SetColumnTitle(1, lng.GetString(STR_HELP_SCORE).c_str());

	helpPanel->lblF1.SetText(lng.GetString(STR_HELP_HSC).c_str());
	helpPanel->lblHelp.SetText(lng.GetString(STR_HELP_TEXT).c_str());
}



void MainGameDialog::HscDialog::MsgInitSkin() {
	Dialog::MsgInitSkin();

	for (int i=0; i<4; i++) {
		lstHsc.SetFont(1, i);
		lstHsc.SetFontColor(theme.hsc_list_col, theme.hsc_list_shd, i);
		lstHsc.GetHeader()->SetFont(1, i);
		lstHsc.GetHeader()->SetFontColor(theme.hsc_header_col, theme.hsc_header_shd, i);
		lblF1.SetFont(1, i);
		lblF1.SetFontColor(theme.help_fg, theme.help_bg, i);
	}
}


MainGameDialog::HscDialog::HscDialog() : Dialog() {
	panel.Shape(0, 0, 168, 240);
	Add(panel);

	lblF1.ClearFlag(D_AUTOSIZE);
	lblF1.Setup(8, 12, 144, 13, 0, 0, "-", 2);
	Add(lblF1);

	lstHsc.Shape(6, 32, 148, 197);
	lstHsc.SetHeader(&hscHeader);
	lstHsc.InsertColumn("-", 0, 2);
	lstHsc.InsertColumn("-", 1, 2);
	lstHsc.SetColumnWidth(0, 100);
	lstHsc.SetColumnWidth(1, 42);
	lstHsc.EnableColumnResizing(false);
	lstHsc.SetHeaderVisibility(false);
	lstHsc.Disable();

	Add(lstHsc);
}


MainGameDialog::HscDialog::~HscDialog() {
	lstHsc.SetHeader(0);
}


void MainGameDialog::HscDialog::FillHscList(HSC *hsc) {
DEBUG
	lstHsc.DeleteAllItems();
DEBUG
	for (int i=0; i<hsc->Count() && i<15; i++) {
DEBUG
		lstHsc.InsertItem(new HscItem(i%2));

		HSC::Entry e = hsc->GetEntry(i);
		static char buf[16];

		usprintf(buf, "%d", i+1);
		lstHsc.SetItem(i, 0, e.name.c_str());
		int min = e.score/(60*100);
		int sec = e.score/100 - min*60;
		int msec = e.score - sec*100 - min*60*100;
		usprintf(buf, "%01d:%02d.%02d", min, sec, msec);
DEBUG
		lstHsc.SetItem(i, 1, buf);
DEBUG
	}
DEBUG
}




void MainGameDialog::HelpDialog::MsgInitSkin() {
	Dialog::MsgInitSkin();

	for (int i=0; i<4; i++) {
		lblHelp.SetFont(1, i);
		lblHelp.SetFontColor(theme.hsc_list_col, theme.hsc_list_shd, i);
		lblF1.SetFont(1, i);
		lblF1.SetFontColor(theme.help_fg, theme.help_bg, i);
	}
}


MainGameDialog::HelpDialog::HelpDialog() : Dialog() {
	panel.Shape(0, 0, 168, 240);
	Add(panel);

	lblF1.ClearFlag(D_AUTOSIZE);
	lblF1.Setup(8, 12, 144, 13, 0, 0, "-", 2);
	Add(lblF1);

	pnlHelp.Shape(8, 32, 144, 197);
	Add(pnlHelp);

	lblHelp.ClearFlag(D_AUTOSIZE);
	lblHelp.Shape(12, 36, 136, 188);
	lblHelp.SetWordWrap(true);
	Add(lblHelp);
}
