#include <math.h>
#include "explosion.h"
#include <MASkinG.h>



EXPLOSION *create_explosion(BITMAP *bmp, int ix, int iy) {
	int x,y,i;

	EXPLOSION *e = (EXPLOSION *)malloc(sizeof(EXPLOSION));

	e->particle_count = bmp->w * bmp->h;
	e->particles = (PARTICLE *)malloc(e->particle_count * sizeof(PARTICLE));

	i = 0;
	for (y=0; y<bmp->h; y++) {
		for (x=0; x<bmp->w; x++) {
			e->particles[i].x = ix+x;
			e->particles[i].y = iy+y;
			e->particles[i].dir = myrand()%256;
			e->particles[i].v = 1.5*((myrand()%100)/100.0+0.5);
			e->particles[i].a = 0.99;
			int col = getpixel(bmp, x, y);
			if (geta(col) > 127) {
				e->particles[i].col = col;
			}
			else {
				e->particles[i].col = makecol(
										myrand()%theme.expl_range_r + theme.expl_offset_r,
										myrand()%theme.expl_range_g + theme.expl_offset_g,
										myrand()%theme.expl_range_b + theme.expl_offset_b);
			}
			e->particles[i].life = (int)(MAS::Settings::logicFrameRate*1.0);
			++i;
		}
	}

	return e;
}


void destroy_explosion(EXPLOSION *e) {
	free(e->particles);
}


int update_explosion(EXPLOSION *e) {
	int done = 1;
	int i;
	int dir;

	for (i=0; i<e->particle_count; i++) {
		if (e->particles[i].life > 0) {
			dir = (int)(e->particles[i].dir);
			e->particles[i].x += e->particles[i].v*SIN[dir];
			e->particles[i].y -= e->particles[i].v*COS[dir];
			e->particles[i].v *= e->particles[i].a;
			e->particles[i].life -= 1;

			done = 0;
		}
	}

	return done;
}


void draw_explosion(EXPLOSION *e, BITMAP *canvas) {
	int i;
	int x;
	int y;

	for (i=0; i<e->particle_count; i++) {
		if (e->particles[i].life > 0) {
			x = (int)e->particles[i].x;
			y = (int)e->particles[i].y;
			putpixel(canvas, x, y, e->particles[i].col);
		}
	}
}
