#ifndef		TANK_H
#define		TANK_H

#include "object.h"
#include "rocket.h"
#include <vector>

class Tank : public Object {
	public:
		int dir;
		int light_counter;
		static int max_light_counter;
		static float max_speed;
		Vector target;
		int shot_counter;
		static int max_shot_counter;

		std::vector<Rocket> *rockets;

	protected:
		void SelectNewTarget();
		void Shoot();

	public:
		Tank();
		virtual ~Tank();

		virtual void Init();
		virtual void Update();
		virtual void Draw(BITMAP *canvas);
};

#endif		//TANK_H
