#include "global.h"
#include "online.h"
#include <curl/curl.h>

#define DBG		printf("%s: %s (%d)\n", __FILE__,__PRETTY_FUNCTION__,__LINE__);
#define DBG3(x,y,z)		printf("%s: %s (%d): %s, %s, %d\n", __FILE__,__PRETTY_FUNCTION__,__LINE__, x,y,z);

CURL *curl = 0;

static bool in_progress = false;
static char dl_buf[4096];
static int dl_index = 0;
static HSC::Entry *upload_entry = 0;

int get_hsc(char *in, int size, int nmemb, void *out)
{
	int r;
	r = size * nmemb;
	memcpy(dl_buf+dl_index, in, r);
	dl_index += r;
	return r;
}


void do_download() {
	curl_easy_setopt(curl, CURLOPT_URL, hsc_url);
	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0);
	curl_easy_setopt(curl, CURLOPT_VERBOSE, 1);
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, get_hsc);

	memset(dl_buf, 0, 4096);
	dl_index = 0;
	curl_easy_perform(curl);

	char *tok = ustrtok(dl_buf, "|");
	if (tok) {
		hsc->Reset();
	}
	while (tok) {
		HSC::Entry e;
		e.name = tok;
		tok = ustrtok(0, "|");
		e.date = tok;
		tok = ustrtok(0, "|");
		e.score = (int)uatof(tok);
		tok = ustrtok(0, "|");

		if (hsc->CanAdd(e.score)) {
			hsc->AddEntry(e);
		}
		else {
			break;
		}
	}

	in_progress = false;
}

void do_upload() {
	if (upload_entry) {
		char qs[256];
		usprintf(qs, "%s?name=%s&date=%s&score=%d", hsc_url, upload_entry->name.c_str(), upload_entry->date.c_str(), upload_entry->score);
		//printf("%s?name=%s&date=%s&score=%d\n", hsc_url, upload_entry->name.c_str(), upload_entry->date.c_str(), upload_entry->score);
		for (int i=0; qs[i]; i++) {
			qs[i] = qs[i] == ' ' ? '_' : qs[i];
		}

		curl_easy_setopt(curl, CURLOPT_URL, qs);
		curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0);
		curl_easy_setopt(curl, CURLOPT_VERBOSE, 1);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, get_hsc);
		memset(dl_buf, 0, 4096);
		dl_index = 0;
		curl_easy_perform(curl);

		delete upload_entry;
		upload_entry = 0;
	}

	in_progress = false;
}

#ifdef		ALLEGRO_WINDOWS

#include <winalleg.h>

static HANDLE hThread  = 0;

DWORD WINAPI HSCDownloadThread(LPVOID lpParameter) {
	do_download();
	return 0;
}


void DownloadHSC() {
	if (!in_progress) {
		in_progress = true;
		hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)(HSCDownloadThread), 0, 0, NULL);
	}
}


DWORD WINAPI EntryUploadThread(LPVOID lpParameter) {
	do_upload();
	return 0;
}


void UploadEntry(HSC::Entry e) {
	if (!in_progress) {
		in_progress = true;
		upload_entry = new HSC::Entry;
		upload_entry->name = e.name;
		upload_entry->date = e.date;
		upload_entry->score = e.score;
		hThread	= CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)(EntryUploadThread), 0, 0, NULL);
	}
}


void KillThreads() {
	if (in_progress) {
		CloseHandle(hThread);
		in_progress = false;
	}
}
#else

#include <pthread.h>

static pthread_t hThread[1];


void *HSCDownloadThread(void *lpParameter) {
	do_download();
	pthread_exit(0);
}


void *EntryUploadThread(void *lpParameter) {
	do_upload();
	pthread_exit(0);
}


void DownloadHSC() {
	if (!in_progress) {
		in_progress = true;
		if (pthread_create(&hThread[0], 0, HSCDownloadThread, 0)) {
			in_progress = false;
		}
	}
}


void UploadEntry(HSC::Entry e) {
	if (!in_progress) {
		in_progress = true;
		upload_entry = new HSC::Entry;
		upload_entry->name = e.name;
		upload_entry->date = e.date;
		upload_entry->score = e.score;
		//printf("%s?name=%s&date=%s&score=%d\n", hsc_url, upload_entry->name.c_str(), upload_entry->date.c_str(), upload_entry->score);
		if (pthread_create(&hThread[0], 0, EntryUploadThread, 0)) {
			in_progress = false;
		}
	}
}


void KillThreads() {
	if (in_progress) {
		pthread_exit(&hThread[0]);
		in_progress = false;
	}
}

#endif
