#include <allegro.h>
#include "global.h"
#include "music_player.h"


static AL_DUH_PLAYER *dplayer;
DUH *music = NULL;


static int _playing_song = -1;

void poll_music() {
	float volume = musicVolume*25/256.0f;

	if (dplayer) {
		al_duh_set_volume(dplayer, volume);
	}

	al_poll_duh(dplayer);
}


void play_music(int id)
{
	DUH_SIGRENDERER *sr = NULL;
	float volume;

	static int offset[] = { 0, 1 };

	if (_playing_song == id) {
		return;
	}

	stop_music();

	//TODO
	if (music) {
		stop_music();
		sr = dumb_it_start_at_order(music, 2, offset[id]);
		volume = musicVolume*25/256.0f;
		dplayer = al_duh_encapsulate_sigrenderer(sr, volume, 8192, 44100);
		_playing_song = id;
	}
}


void stop_music()
{
	if (_playing_song != -1 && dplayer != NULL) {
		al_stop_duh(dplayer);
		_playing_song = -1;
	}
}


void play_sound(SAMPLE *smp, int vol, int pan, int freq, int loop)
{
	if (freq < 0) {
		freq = 1000 + myrand() % (-freq) + freq / 2;
	}

	play_sample(smp, vol*soundVolume/10, pan, freq, loop);
}



void play_2d_sound(SAMPLE *smp, int vol, int freq, int x, int y, int ref_x, int ref_y) {
	int dx = ref_x - x;
	int dy = ref_y - y;
	int d = dx*dx + dy*dy;
	int pan;

	if (d > 320*320) {
		return;
	}

	if (vol < 0) {
		vol = 256 - d/256;
		vol = MID(0, vol, 255);
	}

	pan = 128 + dx*128/192;
	pan = MID(0, 255-pan, 255);

	play_sound(smp, vol, pan, freq, 0);
}
