#include "language.h"
#include <allegro.h>
using namespace std;


Language::Language() {
	for (int i=0; i<STR_COUNT; i++) {
		strings[i] = string("<default>");
	}
}


Language::~Language() {
}


static string names[] = {
	"GAMENAME_SMALL",
	"GAMENAME_LARGE",
	"NYI",
	"BACK",
	"YES",
	"NO",
	"OFF",
	"ABOUT1",
	"ABOUT2",
	"ABOUT3",
	"INTRO1",
	"INTRO2",
	"INTRO3",
	"INTRO4",
	"INTRO5",
	"OUTRO1",
	"OUTRO2",
	"MENU_GAME",
	"MENU_SETTINGS",
	"MENU_HSC",
	"MENU_ABOUT",
	"MENU_EXIT",
	"SETTINGS_GFX",
	"SETTINGS_SOUND",
	"SETTINGS_CPU",
	"SETTINGS_LANGUAGE",
	"GFX_FULLSCREEN",
	"GFX_FRAMERATE",
	"GFX_VSYNC",
	"GFX_SHADOWS",
	"GFX_THEME",
	"SND_SOUND",
	"SND_MUSIC",
	"HSC_POS",
	"HSC_NAME",
	"HSC_DATE",
	"HSC_SCORE",
	"HSC_REPLAYS",
	"HSC_LOCAL",
	"HSC_ONLINE",
	"HSC_NOREPLAY",
	"GAME_PAUSED",
	"GAME_OVER",
	"GAME_RESULT",
	"GAME_ANYKEY",
	"GAME_REPLAY",
	"GAME_ENTERNAME",
	"HELP_TOOLTIP",
	"HELP_INSTRUCTIONS",
	"HELP_HSC",
	"HELP_NAME",
	"HELP_SCORE",
	"HELP_TEXT",
	"TIME_PANEL",
	"REPLAY_MARK",
	"CREDITS"
};


int Language::GetIndex(const std::string &name) {
	for (int i=0; i<STR_COUNT; i++) {
		if (names[i] == name) {
			return i;
		}
	}

	return -1;
}


void Language::SetString(const std::string &name, const std::string &text) {
	int i = GetIndex(name);
	if (i >= 0 && i < STR_COUNT) {
		strings[i] = text;
	}
}


const string Language::GetString(int which) {
	if (which >= 0 && which < STR_COUNT) {
		return strings[which];
	}
	else {
		return "default";
	}
}


void Language::Load(const char *path) {
	PACKFILE *lng = pack_fopen(path, "r");
	if (!lng) {
		return;
	}

	for (int i=0; i<STR_COUNT; i++) {
		strings[i] = string("<default>");
	}

	char buf[4096];
	char buf2[4096];
	while (!pack_feof(lng)) {
		buf[0] = 0;
		pack_fgets(buf, 4096, lng);
		char *tok1 = ustrtok(buf, "=");
		char *tok2 = ustrtok(0, "=");
		if (tok1 && tok2) {
			//ustrcpy(buf2, tok2);
			SetString(string(tok1), string(uconvert(tok2, U_UTF8, buf2, U_ASCII, 4096)));
		}
	}

	pack_fclose(lng);
}
