#ifndef		__HSC_H__
#define		__HSC_H__

#include <vector>
#include <string>

class HSC {
	public:
		class Entry {
			public:
				std::string name;
				std::string date;
				int score;

			public:
				Entry();
		};

		static const int entryLimit = 20;
		std::vector<Entry> scores;

	public:
		HSC();
		~HSC();

		void Load(std::string filename);
		void Save(std::string filename);
		int Count();
		Entry &GetEntry(int i);
		void AddEntry(Entry e);
		bool CanAdd(int score);
		void Reset();
		bool HasTopScore(Entry &e);
};

#endif		//__HSC_H__
