#ifndef		__GLOBAL_H__
#define		__GLOBAL_H__


#include <math.h>
#include <MASkinG.h>
using namespace MAS;

#include "screenshot.h"
#include "fps.h"
#include "hsc.h"
#include "language.h"
#include "theme.h"

#define DEBUG	TRACE("%s: %s (%d)\n",__FILE__,__PRETTY_FUNCTION__,__LINE__);

#define		DODGER_VERSION_MAJOR		1
#define		DODGER_VERSION_MINOR		18

// Interface for our game menu dialogs. All our dialogs will be derived
// from this class and will at least implement the Run() function.
class GameDialog : public Dialog {
	public:
		// This function runs the dialog and returns a unique ID of
		// the dialog that's supposed to be run next (i.e. the next
		// state of the finite state machine that is our menu system).
		virtual int Run() = 0;
		GameDialog();

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0);
		virtual void SetLanguage();

	protected:
		class AnimWidget : public ClearScreen {
			protected:
				void MsgStart();
				void Draw(Bitmap &canvas);
				void MsgDraw();
				void MsgTick();
				bool MsgWantmouse();
				void MsgInitSkin();

				class Transition : public Animator {
					public:
						void Create(Bitmap &bmp, int length);
						void Reset();
				};

				Transition anim;
				bool startedAnimating;
		};

		AnimWidget anim;
		Accelerator acc;

		void MsgTick();
		void MsgDraw();
};


// These are the states the menu system can be in. Every state has a
// matching dialog that is run in that state. The exception is S_EXIT_GAME
// which is a special exit state.
enum {
	S_EXIT_GAME = -1,
	S_MAIN_MENU,
	S_PLAYING,
	S_OPTIONS,
	S_HIGHSCORES,
	S_ABOUT,
	S_INTRO,
	S_OUTRO,
	S_REPLAY,
	S_GFX,
	S_SOUND,

	S_COUNT
};

extern GameDialog *dlg[S_COUNT];

extern BITMAP *back_tile;
extern BITMAP *tank_sprite[4][4];
extern BITMAP *rocket_sprite[4];
extern BITMAP *drone_sprite[8];
extern BITMAP *player_sprite[2];
extern BITMAP *drone_sprite_shd[8];
extern BITMAP *player_sprite_shd[2];

extern SAMPLE *cling_sample;
extern SAMPLE *shot_sample;
extern SAMPLE *explode_sample;

extern SCREENSHOT *screenshot;
extern CFPS fps;

extern HSC *hsc;
extern HSC *local_hsc;
extern char hsc_url[256];

extern bool shadows;

extern Language lng;
extern char lng_filename[256];
void LoadLanguage(const char *path);

extern char theme_name[256];
extern Theme theme;

#define LUT_SIZE 256
extern float SIN[LUT_SIZE+1];
extern float COS[LUT_SIZE+1];

void OutlinePrint(Font &f, Bitmap &canvas, int x, int y, Color col, Color shd, int a, const char *text);


class CustomLabel : public Label {
	protected:
		void MsgInitSkin();
		void Draw(Bitmap &canvas);
		Bitmap cache;
};


class TextButton : public Button {
	protected:
		void MsgInitSkin();
		void Draw(Bitmap &canvas);
		Bitmap cache[4];

	public:
		void SetText(const char *text);
};


class ChoiceButton : public TextButton {
	public:
		int selection;
		std::vector<std::string> choice;

	public:
		ChoiceButton();
		char *GetText();
		void Increment();
		void Decrement();

		bool MsgChar(int c);
		void MsgLPress();
		void MsgRPress();
};


class ScrollingText : public Label {
	protected:
		void Draw(Bitmap &canvas);
		void MsgTick();
		int tick;

	public:
		ScrollingText();
		void LoadText(const char *filename);
};

void Gradient(Bitmap &canvas, int x1, int y1, int x2, int y2, Color c1, Color c2);

class Background : public ClearScreen {
	protected:
		void Draw(Bitmap &canvas);
};

struct GlobalWidgets {
	CustomLabel title;
	ScrollingText lblBottom;
};

extern GlobalWidgets *globalWidgets;
extern Cursor *cur;
extern int soundVolume;
extern int musicVolume;

void InitData();
void LoadData(const char *dir);
void UnloadData();

class HscItem : public MAS::ListBoxEx::Item {
	protected:
		bool odd;

		void DrawBackground(Bitmap &dst, int state, const Rect &dstRect);

	public:
		HscItem(bool odd) : ListBoxEx::Item() {
			this->odd = odd;
		}

		int h() {
			return 13;
		}
};

class HscHeader : public MAS::ListBoxEx::Header {
	protected:
		void DrawItemBackground(Bitmap &dst, MAS::ListBoxEx::Column* item, int state, const Rect &dstRect) {
			dst.Rectfill(dstRect, Color::black);
			dst.Hline(dstRect.x(), dstRect.y2()-1, dstRect.x2()-1, Color(0,255,0));
		}
};



int myrand(void);
void mysrand(unsigned seed);

#endif		//__GLOBAL_H__
