#ifndef		__GAME_DIALOG_H__
#define		__GAME_DIALOG_H__

#include "global.h"
#include "gamewidget.h"
#include "timepanel.h"
#include "hsc.h"


class MainGameDialog : public GameDialog {
	protected:
		GameWidget desktop;
		TimePanel timePanel;
		HSC *current_hsc;
		int hsc_counter;

		class HscDialog : public Dialog {
			protected:
				Panel panel;
				Label lblF1;
				ListBoxEx lstHsc;
				HscHeader hscHeader;

				void MsgInitSkin();

			public:
				HscDialog();
				~HscDialog();

				void FillHscList(HSC *hsc);
				friend class MainGameDialog;
		};

		class HelpDialog : public Dialog {
			protected:
				Panel panel;
				Label lblF1;
				PanelSunken pnlHelp;
				Label lblHelp;

				void MsgInitSkin();

			public:
				HelpDialog();
				friend class MainGameDialog;
		};

		HscDialog *hscPanel;
		HelpDialog *helpPanel;
		Accelerator acc;

		// 0 = hsc is on
		// 1 = hiding hsc
		// 2 = showing help
		// 3 = help is on
		// 4 = hidinh help
		// 5 = showing hsc
		int state;
		int progress;
		int duration;

		int ret;

	protected:
		void MsgTick();

	public:
		MainGameDialog();
		~MainGameDialog();
		int Run();
		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0);
		void SetLanguage();
};

#endif		//__GAME_DIALOG_H__
