/*
 * Allegro DIALOG Editor
 * by Julien Cugniere
 *
 * dedit.h : The core of the editor
 */

#ifndef DEDIT_H
#define DEDIT_H

#include <allegro.h>

#ifdef __cplusplus
	extern "C" {
#endif

#define DLG_VERSION_STR "0.43"
#define DLG_DATE_STR    "2003/04/10"


/* a supported dialog procedure, with default parameters */
typedef struct PROC
{
	DIALOG_PROC proc;
	char *sproc;

	char *sfg, *sbg;
	char *skey, *sflags;
	char *sd1, *sd2;

	void *dp;
	char *sdp;

	void *dp2;
	char *sdp2;

	void *dp3;
	char *sdp3;

	int id_param;
} PROC;


/* id_param: bitfield of the params to display to represent the object */
#define POS 1
#define KEY 2
#define D1  4
#define D2  8
#define DP  16
#define DP2 32
#define DP3 64


/* use this macro to fill a PROC array. For example:
 * PROC default_procs[] =
 * {
 *    // (proc)         fg   bg   key   flg   d1   d2   dp       dp2    dp3    ID_param
 *    P( d_clear_proc,  0,   0,   0,    0,    0,   0,   NULL,    NULL,  NULL,  0      ),
 *    P( d_text_proc,   0,   0,   0,    0,    0,   0,   "text",  NULL,  NULL,  DP     ),
 *    { 0 }
 * };
 */
#define P(p, fg, bg, k, f, d1, d2, dp, dp2, dp3, idp) \
	{ p, #p, #fg, #bg, #k, #f, #d1, #d2, dp, #dp, dp2, #dp2, dp3, #dp3, idp }


/* dummy parameters to use in custom PROCs */
extern BITMAP *dummy_bmp;
extern MENU dummy_menu[];
char *dummy_getter(int, int*);
int dummy_proc(void);


/* the plugin API */
void register_proc_set(PROC *set, char *name);
void register_menu_hook(MENU *menu);
void register_reinit_callback(void (*callback)(void));
void register_shutdown_callback(void (*callback)(void));


/* the main editor functions */
void dialog_editor(char *path, char *name);
void set_dialog_gui_state(void);
void set_editor_gui_state(void);


#ifdef __cplusplus
	}
#endif

#endif /* DEDIT_H */
