/*
 * Allegro DIALOG Editor
 *
 * Plugin adding support for the internal procedures of the editor.
 *
 * The code for these is in src/guiprocs.c
 */

#include <allegro.h>
#include "../src/dedit.h"
#include "../src/guiprocs.h"



/*  the proc set used for registration */
static PROC dlg_gui_procs[] =
{
	/* (proc)            fg  bg  key  flg  d1  d2  dp             dp2    dp3    ID_param */
	P( xtext_proc,       0,  0,  0,   0,   0,  0,  "xtext",       NULL,  NULL,  DP|D1 ),
	P( xctext_proc,      0,  0,  0,   0,   0,  0,  "xtext",       NULL,  NULL,  DP|D1 ),
	P( xrtext_proc,      0,  0,  0,   0,   0,  0,  "xtext",       NULL,  NULL,  DP|D1 ),
	P( xbox_proc,        0,  0,  0,   0,   0,  0,  NULL,          NULL,  NULL,  POS ),
	P( xcolorbox_proc,   0,  0,  0,   0,   0,  0,  NULL,          NULL,  NULL,  POS ),
	P( xbutton_proc,     0,  0,  0,   0,   0,  0,  "xbutton",     NULL,  NULL,  DP  ),
	P( xcheck_proc,      0,  0,  0,   0,   1,  0,  "xcheck",      NULL,  NULL,  DP  ),
	P( xedit_proc,       0,  0,  0,   0,   5,  0,  "xedit",       NULL,  NULL,  DP  ),
	P( xlist_proc,       0,  0,  0,   0,   0,  0,  dummy_getter,  NULL,  NULL,  DP  ),
	P( xtext_list_proc,  0,  0,  0,   0,   0,  0,  dummy_getter,  NULL,  NULL,  DP  ),
	P( xtextbox_proc,    0,  0,  0,   0,   0,  0,  "xtextbox",    NULL,  NULL,  DP  ),
	P( xpalette_proc,    0,  0,  0,   0,   0,  0,  NULL,          NULL,  NULL,  0   ),
	{ 0 }
};



void install_dlg_gui_plugin(void)
{
	register_proc_set(dlg_gui_procs, "dlg_gui");
}
