/*
 * dlg plugin adding bgui2 support
 */

#include <allegro.h>
#include <tdgui.h>
#include "../src/dedit.h"



/* here's a custom callback for d_ex_billbutton_proc */
static int my_callback(void *dp3, int d2)
{
	char s[200];
	usprintf(s, "dp3 = %s, d2 = %d", (char*)dp3, d2);
	billalert("Callback", s, NULL, "OK", NULL, 13, 0);
	return D_O_K;
}



/* the proc set used for registration */
static PROC bgui_procs[] =
{
	/* (proc)                       fg  bg  key flg d1  d2  dp            dp2          dp3      ID_param */
	P( d_billclear_proc,            0,  0,  0,  0,  0,  0,  NULL,         NULL,        NULL,    0      ),
	P( d_billwin_proc,              0,  0,  0,  0,  0,  0,  "Window",     NULL,        NULL,    DP     ),
	P( d_billscrollablebitmap_proc, 0,  0,  0,  0,  0,  0,  NULL,         NULL,        NULL,    DP     ),
	P( d_billgroupbox_proc,         0,  0,  0,  0,  0,  0,  "Group",      NULL,        NULL,    DP     ),
	P( d_billhline_proc,            0,  0,  0,  0,  0,  0,  NULL,         NULL,        NULL,    POS    ),
	P( d_billvline_proc,            0,  0,  0,  0,  0,  0,  NULL,         NULL,        NULL,    POS    ),
	P( d_billmenu_proc,             0,  0,  0,  0,  0,  0,  dummy_menu,   NULL,        NULL,    DP     ),
	P( d_billtext_proc,             0,  0,  0,  0,  0,  0,  "text",       NULL,        NULL,    DP     ),
	P( d_billctext_proc,            0,  0,  0,  0,  0,  0,  "ctext",      NULL,        NULL,    DP     ),
	P( d_billtextbox_proc,          0,  0,  0,  0,  0,  0,  "textbox",    NULL,        NULL,    DP     ),
	P( d_billbutton_proc,           0,  0,  0,  0,  0,  0,  "Button",     NULL,        NULL,    DP     ),
	P( d_callback_billbutton_proc,  0,  0,  0,  0,  0,  0,  "cButton",    dummy_proc,  NULL,    DP|DP2 ),
	P( d_ex_billbutton_proc,        0,  0,  0,  0,  0,  0,  "xButton",    my_callback, "hello", DP     ),
/*	P( d_samplex_billbutton_proc,   0,  0,  0,  0,  0,  0,  NULL,         NULL,        NULL,    0      ), */
	P( d_billcheck_proc,            0,  0,  0,  0,  1,  0,  "check",      NULL,        NULL,    DP     ),
	P( d_billradio_proc,            0,  0,  0,  0,  0,  0,  "radio",      NULL,        NULL,    DP|D1  ),
	P( d_billedit_proc,             0,  0,  0,  0,  4,  0,  "edit",       NULL,        NULL,    DP     ),
	P( d_billlist_proc,             0,  0,  0,  0,  0,  0,  dummy_getter, NULL,        NULL,    DP|DP2 ),
	P( d_billddlist_proc,           0,  0,  0,  0,  0,  0,  dummy_getter, NULL,        NULL,    DP     ),
	P( d_billprogress_proc,         0,  0,  0,  0,  8,  6,  NULL,         NULL,        NULL,    D1     ),
	P( d_billslider_proc,           0,  0,  0,  0,  8,  6,  NULL,         NULL,        NULL,    D1     ),
	P( d_hbillscrollbar_proc,       0,  0,  0,  0,  8,  6,  NULL,         NULL,        NULL,    D1     ),
	P( d_vbillscrollbar_proc,       0,  0,  0,  0,  8,  6,  NULL,         NULL,        NULL,    D1     ),
	{ 0 }
};



/* initialization */
void install_bgui_plugin(void)
{
	int i;

	bill_init();
	set_gui_mode(1);

	/* Three things to note:
	 *
	 * - To initialize a plugin, you can use the dummy_* parameters provided
	 *   by the editor (see dedit.h), or create your own here.
	 *
	 * - Bitmaps, being created at run-time, require run-time initialization.
	 *
	 * - When manually setting the proc, dp, dp2 and dp3 parameters in the
	 *   PROC structure, you have to set both the real parameter, and its
	 *   text equivalent (sproc, sdp, ...).
	 */
	for (i=0; bgui_procs[i].proc; i++) {
		if (ustrcmp(bgui_procs[i].sproc, "d_billscrollablebitmap_proc") == 0) {
			bgui_procs[i].dp = dummy_bmp;
			bgui_procs[i].sdp = "dummy_bmp";
		}
	}

	register_proc_set(bgui_procs, "bgui");
}



