/*
 * Allegro DIALOG Editor
 *
 * Plugin adding support for the default GUI procedures
 */

#include <allegro.h>
#include "../src/dedit.h"



/*  the proc set used for registration */
static PROC allegro_procs[] =
{
	/* (proc)             fg  bg  key  flg  d1   d2   dp            dp2     dp3    ID_param */
	P( d_clear_proc,      0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  0     ),
	P( d_box_proc,        0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  POS   ),
	P( d_shadow_box_proc, 0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  POS   ),
	P( d_bitmap_proc,     0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  DP    ),
	P( d_text_proc,       0,  0,  0,   0,   0,   0,   "text",       NULL,   NULL,  DP    ),
	P( d_ctext_proc,      0,  0,  0,   0,   0,   0,   "ctext",      NULL,   NULL,  DP    ),
	P( d_rtext_proc,      0,  0,  0,   0,   0,   0,   "rtext",      NULL,   NULL,  DP    ),
	P( d_button_proc,     0,  0,  0,   0,   0,   0,   "button",     NULL,   NULL,  DP    ),
	P( d_check_proc,      0,  0,  0,   0,   1,   0,   "check",      NULL,   NULL,  DP    ),
	P( d_radio_proc,      0,  0,  0,   0,   0,   0,   "radio",      NULL,   NULL,  D1|DP ),
	P( d_icon_proc,       0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  DP    ),
	P( d_keyboard_proc,   0,  0,  0,   0,   0,   0,   dummy_proc,   NULL,   NULL,  KEY|D1|D2|DP ),
	P( d_edit_proc,       0,  0,  0,   0,   4,   0,   "edit",       NULL,   NULL,  DP    ),
	P( d_list_proc,       0,  0,  0,   0,   0,   0,   dummy_getter, NULL,   NULL,  DP    ),
	P( d_text_list_proc,  0,  0,  0,   0,   0,   0,   dummy_getter, NULL,   NULL,  DP    ),
	P( d_textbox_proc,    0,  0,  0,   0,   0,   0,   "text box",   NULL,   NULL,  DP    ),
	P( d_slider_proc,     0,  0,  0,   0,   16,  4,   NULL,         NULL,   NULL,  D1    ),
	P( d_menu_proc,       0,  0,  0,   0,   0,   0,   dummy_menu,   NULL,   NULL,  DP    ),
	P( d_yield_proc,      0,  0,  0,   0,   0,   0,   NULL,         NULL,   NULL,  0     ),
	{ 0 }
};



/* initialization */
void install_allegro_plugin(void)
{
	int i;

	/* Three things to note:
	 *
	 * - To initialize a plugin, you can use the dummy_* parameters provided
	 *   by the editor (see dedit.h), or create your own here.
	 *
	 * - Bitmaps, being created at run-time, require run-time initialization.
	 *
	 * - When manually setting the proc, dp, dp2 and dp3 parameters in the
	 *   PROC structure, you have to set both the real parameter, and its
	 *   text equivalent (sproc, sdp, ...).
	 */
	for (i=0; allegro_procs[i].proc; i++) {
		/* Not always valid due to calling conventions (cf. MSVC):
		 * if(allegro_procs[i].proc == d_bitmap_proc ||
		 *    allegro_procs[i].proc == d_icon_proc)
		 */
		if (ustrcmp(allegro_procs[i].sproc, "d_bitmap_proc") == 0 ||
		    ustrcmp(allegro_procs[i].sproc, "d_icon_proc") == 0) {
			allegro_procs[i].dp = dummy_bmp;
			allegro_procs[i].sdp = "dummy_bmp";
		}
	}

	register_proc_set(allegro_procs, "allegro");
}



