/*
 * Allegro DIALOG Editor
 *
 * Quick'n'dirty tetris, just for fun!
 */

#include "../src/dedit.h"
#include "../src/guiprocs.h"
#include <stdlib.h>
#include <string.h>
#include <allegro.h>

#define GW         (10+2)
#define GH         (20+1)
#define DX(a)      (((a)%5)-2)
#define DY(a)      (((a)/5)-2)
#define BL(dx, dy) ((dy+2)*5 + (dx+2))

static const char blocks[7][4] =
{
	{ 2, 7, 12, 17 },
	{ 6, 7, 11, 12 },
	{ 6, 7, 12, 13 },
	{ 7, 8, 11, 12 },
	{ 6, 11, 12, 13 },
	{ 7, 11, 12, 13 },
	{ 8, 11, 12, 13 },
};

static char grid[GH][GW];
static char block[4];
static int bx, by;
static int lines, next, speed;

static void put_block(const char b[], int x, int y, char c)
{
	int i;
	for (i = 0; i < 4; i++)
		grid[y+DY(b[i])][x+DX(b[i])] = c;
}

static int collide(const char b[], int x, int y)
{
	int i;
	for (i = 0; i < 4; i++)
		if (grid[y+DY(b[i])][x+DX(b[i])])
			return 1;
	return 0;
}

static void rotate(void)
{
	int i;
	put_block(block, bx, by, 0);
	for (i = 0; i < 4; i++)
		block[i] = BL(-DY(block[i]), DX(block[i]));
	if (collide(block, bx, by))
		for (i = 0; i < 4; i++)
			block[i] = BL(DY(block[i]), -DX(block[i]));
	put_block(block, bx, by, 1);
}

static int move(int dx, int dy)
{
	put_block(block, bx, by, 0);
	if (collide(block, bx+dx, by+dy))
		dx = dy = 0;
	put_block(block, bx+=dx, by+=dy, 1);
	return (dx || dy);
}

static int check_line(int y)
{
	int x;
	for (x = 1; x < GW-1; x++)
		if (grid[y][x] == 0)
			return 0;
	return 1;
}

static void draw_square(int ox, int oy, int draw)
{
	if (draw) {
		rectfill(screen, ox+1, oy+1, ox+5, oy+5, gui_back_color);
		gui_rect(screen, ox, oy, 7, 7, 0);
	}
	else
		rectfill(screen, ox, oy, ox+6, oy+6, gui_white_color);
}

static void draw_grid(int ox, int oy)
{
	int x, y;
	for (x = 0; x < GW-2; x++)
		for (y = 0; y < GH-1; y++)
			draw_square(ox + x*8, oy + y*8, grid[y][x+1]);
}

static void draw_block(const char b[], int ox, int oy, int draw)
{
	int i;
	for (i = 0; i < 4; i++)
		draw_square(ox+(2+DX(b[i]))*8, oy+(2+DY(b[i]))*8, draw);
}

static void next_block(int nx, int ny)
{
	bx = GW/2;
	by = 2;
	speed = MAX(4, 900/(10+lines));
	memcpy(block, blocks[next], sizeof(block));
	put_block(block, bx, by, 1);
	draw_block(blocks[next], nx, ny, 0);
	next = rand()%7;
	draw_block(blocks[next], nx, ny, 1);
	clear_keybuf();
}

static int tetris(void)
{
	int i, t, quit;
	int w = (GW+5+1) * 8;
	int h = (GH+1) * 8;
	int ox = (SCREEN_W - w) / 2;
	int oy = (SCREEN_H - h) / 2;
	char msg[256];

	scare_mouse();
	gui_rect(screen, ox-1, oy-1, w+2, h+2, 0);
	rectfill(screen, ox, oy, ox+w-1, oy+h-1, gui_back_color);
	gui_rect(screen, ox+6, oy+6, (GW-2)*8+3, (GH-1)*8+3, F_IN);
	rectfill(screen, ox+7, oy+7, ox+7 + (GW-2)*8+1, oy+7 + (GH-1)*8+1, gui_white_color);
	gui_rect(screen, ox+GW*8-2, oy+24-2, 4*8+4, 4*8+4, F_IN);
	rectfill(screen, ox+GW*8-1, oy+24-1, ox+GW*8+4*8, oy+24+4*8, gui_white_color);
	text_mode(gui_back_color);
	textout(screen, font, "Next:",  ox+GW*8, oy+8, gui_text_color);
	textout(screen, font, "Lines:", ox+GW*8, oy+72, gui_text_color);

	memset(grid, 1, sizeof(grid));
	for (i = 0; i < GH-1; i++)
		memset(&grid[i][1], 0, GW-2);

	quit = t = lines = 0;
	next = rand()%7;
	next_block(ox+GW*8, oy+24);
	while (!quit) {
		t = (t+1)%speed;
		if (keypressed()) {
			switch (readkey()>>8) {
				case KEY_ESC:   quit = 1;    break;
				case KEY_LEFT:  move(-1, 0); break;
				case KEY_RIGHT: move(1, 0);  break;
				case KEY_DOWN:  t = 0;       break;
				case KEY_SPACE: rotate();    break;
			}
		}
		if (t == 0) {
			if (!move(0, 1)) {
				if (by == 2)
					quit = 1;
				else {
					for (i = MAX(0, by-2); i < MIN(by+3, GH-1); i++) {
						if (check_line(i)) {
							lines++;
							memmove(grid[1], grid[0], GW*i);
							memset(grid[0]+1, 0, GW-2);
							draw_grid(ox+8, oy+8);
							rest(100);
						}
					}
					next_block(ox+GW*8, oy+24);
				}
			}
		}
		draw_grid(ox+8, oy+8);
		textprintf(screen, font, ox+GW*8, oy+72+16, makecol(0, 0, 0), "  %d ", lines);
		rest(20);
	}
	unscare_mouse();
	usprintf(msg, "lines: %d", lines);
	alert("   GAME OVER !   ", "---", msg, " Ok ", NULL, 0, 0);

	return D_REDRAW;
}

static MENU menu_tetris = { "Tetris", tetris, NULL, 0, NULL };

void install_tetris_plugin(void)
{
	register_menu_hook(&menu_tetris);
}
