#!/bin/sh
#
# Sets up the package for building with the specified compiler,
# and if possible converts text files to the desired target format.
#
# Cut&Pasted from allegro's fix.sh

proc_help()
{
   echo
   echo " Usage: ./fix.sh <platform> [-q|--quick|--dtou|--utod|--utom|--mtou]"
   echo
   echo " Where platform is one of: bcc32, beos, djgpp, mingw32, msvc, qnx, unix"
   echo " and watcom."
   echo " The --quick parameter turns off text file conversion, --dtou converts from"
   echo " DOS/Win32 format to Unix, --utod converts from Unix to DOS/Win32 format,"
   echo " --utom converts from Unix to Macintosh format and --mtou converts from"
   echo " Macintosh to Unix format. If no parameter is specified --dtou is assumed."
   echo

   DLG_NOCONV="1"
}

proc_fix()
{
   echo " Configuring dlg for $1..."

   if [ "$2" != "none" ]; then
      echo "# generated by fix.sh $1"   >  makefile
      echo "MAKEFILE_INC = make/$2.mak" >> makefile
      echo "include make/makefile"      >> makefile
      rm -f src/plugins.h
   fi
}

proc_filelist()
{
   DLG_FILELIST=`find . -type f "(" \
      -name "*.c" -o -name "*.cpp" -o -name "*.h" -o \
      -name "*.txt" -o -name "makefile" -o -name "*.mak" -o -name "*.bat" \
   ")"`

   # touch unix shell scripts?
   if [ "$1" != "omit_sh" ]; then
      DLG_FILELIST="$DLG_FILELIST `find . -type f -name '*.sh'`"
   fi
}

proc_utod()
{
   echo " Converting files from Unix to DOS/Win32..."
   proc_filelist "omit_sh"
   for file in $DLG_FILELIST; do
      echo " $file"
      cp $file _tmpfile
      perl -p -i -e "s/([^\r]|^)\n/\1\r\n/" _tmpfile
      touch -r $file _tmpfile
      mv _tmpfile $file
   done
}

proc_dtou()
{
   echo " Converting files from DOS/Win32 to Unix..."
   proc_filelist
   for file in $DLG_FILELIST; do
      echo " $file"
      mv $file _tmpfile
      tr -d '\015' < _tmpfile > $file
      touch -r _tmpfile $file
      rm _tmpfile
   done
   chmod +x *.sh
}

proc_utom()
{
   echo " Converting files from Unix to Macintosh..."
   proc_filelist "omit_sh"
   for file in $DLG_FILELIST; do
      echo " $file"
      mv $file _tmpfile
      tr '\012' '\015' < _tmpfile > $file
      touch -r _tmpfile $file
      rm _tmpfile
   done
}

proc_mtou()
{
   echo " Converting files from Macintosh to Unix..."
   proc_filelist
   for file in $DLG_FILELIST; do
      echo " $file"
      mv $file _tmpfile
      tr '\015' '\012' < _tmpfile > $file
      touch -r _tmpfile $file
      rm _tmpfile
   done
}

# prepare dlg for the given platform.

case "$1" in
   "mingw32" ) proc_fix "Windows/Mingw32" "$1";;
   "bcc32"   ) proc_fix "Windows/BCC32"   "$1";;
   "msvc"    ) proc_fix "Windows/MSVC"    "$1";;
   "djgpp"   ) proc_fix "DOS/djgpp"       "$1";;
   "watcom"  ) proc_fix "DOS/Watcom"      "$1";;
   "beos"    ) proc_fix "BeOS"            "$1";;
   "qnx"     ) proc_fix "QNX"             "$1";;
   "unix"    ) proc_fix "Unix"            "$1";;
   *         ) proc_help;;
esac

# convert all text-file line endings.

if [ "$DLG_NOCONV" != "1" ]; then
   case "$2" in
      "--utod"  ) proc_utod;;
      "--dtou"  ) proc_dtou;;
      "--utom"  ) proc_utom;;
      "--mtou"  ) proc_mtou;;
      "--quick" ) echo " No text file conversion...";;
      "-q"      ) echo " No text file conversion...";;
      *         ) proc_dtou;;
   esac
fi

echo " Done!"
