@echo off
rem Batch file adaptated from allegro's
rem Sets up the package for building with the specified compiler,
rem and if possible converts text files from LF to CR/LF format.

if [%1] == [bcc32]   goto fix
if [%1] == [djgpp]   goto fix
if [%1] == [mingw32] goto fix
if [%1] == [msvc]    goto fix
if [%1] == [watcom]  goto fix
goto help


:help
echo.
echo. Usage: fix platform [--quick or -q]
echo.
echo. Where platform is one of: bcc32, djgpp, mingw32, msvc, or watcom.
echo. The --quick (or -q) parameter is used to turn off LF to CR/LF conversion.
echo.
goto exit


:fix
echo. Configuring the makefile...
echo # generated by `fix %1'    >  makefile
echo MAKEFILE_INC = make/%1.mak >> makefile
echo include make/makefile      >> makefile
echo this will prevent del from complaining if the file wasnt there > src\plugins.h
del src\plugins.h
if [%1] == [bcc32]   goto done
if [%1] == [mingw32] goto done
if [%2] == [--quick] goto done
if [%2] == [-q]      goto done
echo. Converting files to CR/LF format...
utod make\makefile src\*.* plugins\*.c plugins\*.mak
utod *.txt *.bat


:done
echo. Done!


:exit
