/*
 * Allegro DIALOG Editor
 *
 * Plugin adding support for the AGUP procedures
 */

#include <allegro.h>
#include "agup/agup.h"
#include "agup/aphoton.h"
#include "agup/awin95.h"
#include "agup/agtk.h"
#include "../src/dedit.h"



/* the proc set used for registration */
static PROC agup_procs[] =
{
	/* (proc)                   fg  bg  key  flg  d1   d2  dp             dp2    dp3    ID_param */
	P( d_agup_box_proc,         0,  0,  0,   0,   0,   0,  NULL,          NULL,  NULL,  POS    ),
	P( d_agup_shadow_box_proc,  0,  0,  0,   0,   0,   0,  NULL,          NULL,  NULL,  POS    ),
	P( d_agup_button_proc,      0,  0,  0,   0,   0,   0,  "button",      NULL,  NULL,  DP     ),
	P( d_agup_push_proc,        0,  0,  0,   0,   0,   0,  "push",        NULL,  NULL,  DP|DP3 ),
	P( d_agup_check_proc,       0,  0,  0,   0,   1,   0,  "check",       NULL,  NULL,  DP     ),
	P( d_agup_radio_proc,       0,  0,  0,   0,   0,   0,  "radio",       NULL,  NULL,  D1|DP  ),
	P( d_agup_icon_proc,        0,  0,  0,   0,   0,   0,  NULL,          NULL,  NULL,  DP     ),
	P( d_agup_edit_proc,        0,  0,  0,   0,   4,   0,  "edit",        NULL,  NULL,  DP     ),
	P( d_agup_list_proc,        0,  0,  0,   0,   0,   0,  dummy_getter,  NULL,  NULL,  DP     ),
	P( d_agup_text_list_proc,   0,  0,  0,   0,   0,   0,  dummy_getter,  NULL,  NULL,  DP     ),
	P( d_agup_textbox_proc,     0,  0,  0,   0,   0,   0,  "text box",    NULL,  NULL,  DP     ),
	P( d_agup_slider_proc,      0,  0,  0,   0,   16,  4,  NULL,          NULL,  NULL,  D1     ),
	P( d_agup_menu_proc,        0,  0,  0,   0,   0,   0,  dummy_menu,    NULL,  NULL,  DP     ),
	P( d_agup_window_proc,      0,  0,  0,   0,   0,   0,  "window",      NULL,  NULL,  POS|DP ),
	{ 0 }
};



/* the menu hook */
static int theme_selector(void);
static int current_theme = 0;

static MENU menu_themes[] =
{
/*	(text)       (proc)          (child) (flags) (dp) */
	{ "&gtk",    theme_selector, NULL,   0,      NULL },
	{ "&photon", theme_selector, NULL,   0,      NULL },
	{ "&win95",  theme_selector, NULL,   0,      NULL },
	{ 0 }
};

static MENU agup_menu = { "AGUP theme", NULL, menu_themes, 0, NULL };



/* theme selector menu callback */
static int theme_selector(void)
{
	menu_themes[current_theme].flags &= ~D_SELECTED;
	current_theme = active_menu - menu_themes;
	active_menu->flags |= D_SELECTED;

	/* menu callbacks are called from the menu of the editor, so the allegro
	 * GUI will be in the state used by the editor. We don't want to mess
	 * with it, so we have to change to the correct GUI state before doing
	 * anything. This only applies to menu callbacks, though. See plugins.txt
	 * for more information.
	 */
	set_dialog_gui_state();
	agup_shutdown();
	agup_init((struct agup_theme*)active_menu->dp);
	set_editor_gui_state();

	return D_REDRAW;
}



/* reinitialize the library */
static void reinit(void)
{
	agup_shutdown();
	agup_init((struct agup_theme*)menu_themes[current_theme].dp);
}



/* startup function */
void install_agup_plugin(void)
{
	int i;

	/* Three things to note:
	 *
	 * - To initialize a plugin, you can use the dummy_* parameters provided
	 *   by the editor (see dedit.h), or create your own here.
	 *
	 * - Bitmaps, being created at run-time, require run-time initialization.
	 *
	 * - When manually setting the proc, dp, dp2 and dp3 parameters in the
	 *   PROC structure, you have to set both the real parameter, and its
	 *   text equivalent (sproc, sdp, ...).
	 */
	for (i=0; agup_procs[i].proc; i++) {
		if (ustrcmp(agup_procs[i].sproc, "d_agup_icon_proc") == 0) {
			agup_procs[i].dp = dummy_bmp;
			agup_procs[i].sdp = "dummy_bmp";
		}
	}

	menu_themes[0].dp = (void*)agtk_theme;
	menu_themes[1].dp = (void*)aphoton_theme;
	menu_themes[2].dp = (void*)awin95_theme;

	current_theme = 0;
	menu_themes[current_theme].flags |= D_SELECTED;
	agup_init(agtk_theme);

	register_proc_set(agup_procs, "agup");
	register_menu_hook(&agup_menu);
	register_reinit_callback(reinit);
}
