/*
 * Allegro DIALOG Editor
 * by Julien Cugniere
 *
 * fileops.h : File handling functions
 */

#ifndef FILEOPS_H
#define FILEOPS_H

#include <allegro.h>
#include <stdio.h>

#ifdef __cplusplus
	extern "C" {
#endif


#define FREE_dp       1
#define FREE_dp2      2
#define FREE_dp3      4
#define GOT_MSG_START 8

/* this contains a dialog in a text format: as in a source file */
typedef struct
{
	int x, y, w, h;
	int flags;
	DIALOG *d;

	char *sproc;
	char *sx, *sy, *sw, *sh;
	char *sfg, *sbg;
	char *skey, *sflags;
	char *sd1, *sd2;
	char *sdp, *sdp2, *sdp3;
} TDIALOG;


/* this contains a list of dialogs found in a source file */
typedef struct
{
	int n;
	char **name;
	long *offset;
} SCAN_INFO;


char *fread_parameter(FILE *f, char *buff, int buffsize);
int fcheck(FILE *f, char *fmt);
SCAN_INFO *create_scan_info(void);
SCAN_INFO *fscan_for_dialogs(char *path);
void destroy_scan_info(SCAN_INFO *s);
int fread_dialog_struct(FILE *f, TDIALOG *td);
char *make_source(TDIALOG *td, int tdsize, char *name, int cpp);
void write_dialog(TDIALOG *td, int tdsize, char *path, char *name, long offset, int backup, int cpp);


#ifdef __cplusplus
	}
#endif

#endif /* FILEOPS_H */
