/*****************************************************************************
****************************** PLAYER MODULE *********************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class Player
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include "player.h"
#include "DISEerr.h"
#include <fstream>

using std::endl;
using namespace PLAYER;

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
extern int DEBUG_TEXT_LINE;
extern std::fstream diserrorlog;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

ControllerConfig DefaultControllerConfig = {
   KEY_W, KEY_S, KEY_A, KEY_D,   // directions
   KEY_SPACE, KEY_DEL,           // confirm, cancel
   KEY_ENTER, KEY_CIRCUMFLEX };  // start, select

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class Player                                  *
*****************************************************************************/

// Default constructor
Player::Player()
{
   // Default to field mode
   flag.mode = PLAYER::FIELD_MODE;
   // Keyboard config
   button.up    = KEY_W;
   button.down  = KEY_S;
   button.left  = KEY_A;
   button.right = KEY_D;
   button.confirm = KEY_SPACE;
   button.cancel  = KEY_DEL;
   button.start   = KEY_ENTER;
   button.select  = KEY_CIRCUMFLEX;
   
   lbp = static_cast<Button::Button>(0); // no button pressed
   message = GMSG::NULL_MESSAGE;

   heroptr = NULL;
   pMap = NULL;
   pGraphicEngine = NULL;
}

Player::Player( Map* mapptr, GraphicEngine* gfxengptr)
{
   // Default to field mode
   flag.mode = PLAYER::FIELD_MODE;
   // Keyboard config
   button = DefaultControllerConfig;

   lbp = static_cast<Button::Button>(0); // no button pressed
   message = GMSG::NULL_MESSAGE;

   heroptr = new Being;
   heroptr->setPosition(2,2);
   pMap = mapptr;
   pGraphicEngine = gfxengptr;
   
   pMap->insertThing( heroptr, (heroptr->getPosition()).x, (heroptr->getPosition()).y );
}

// Destructor
Player::~Player()
{
   diserrorlog << "hero @ ("
            << heroptr->getPosition().x << ','
            << heroptr->getPosition().y << ')'
            << endl;
   delete heroptr;
}

// Copy constructor
Player::Player( const Player &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
Player& Player::operator= ( const Player &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//----------------|
// PUBLIC METHODS |
//----------------|

// Returns 0 if key is not for this player
int Player::TranslateKey( int k )
{
   k = (k >> 8);
   if( k == button.left )
      lbp = Button::LEFT;
   else
   if( k == button.right )
      lbp = Button::RIGHT;
   else
   if( k == button.up )
      lbp = Button::UP;
   else
   if( k == button.down )
      lbp = Button::DOWN;
   else
      return 0; // Key is not mine!
      
   return lbp;
}

Message Player::UseButton()
{
   if( flag.mode == FIELD_MODE )
   {
      if ( lbp < Button::CONFIRM )
      {
         switch (lbp)
         {
            case Button::LEFT :
               message.param1.i = Direction::WEST;
               break;
            case Button::RIGHT :
               message.param1.i = Direction::EAST;
               break;
            case Button::UP :
               message.param1.i = Direction::NORTH;
               break;
            case Button::DOWN :
               message.param1.i = Direction::SOUTH;
               break;
         }
         message.msg        = GMSG::WALK;
         message.ptr1       = getPlayerCharacter();
         message.param2.ptr = pMap;
         return message;
      }
      else   // non directional buttons
         return GMSG::NULL_MESSAGE;
   }
   return GMSG::NULL_MESSAGE;
}


/*****************************************************************************
******************************************************************************
****                 Module Public Functions Prototypes                   ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
