/*****************************************************************************
********************** Operations Between basic types ************************
* version 0.00.000 ***********************************************************
********************************************************** October 2004 ******
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - struct intXY
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, October 2004.                                       *
*                                                                            *
*****************************************************************************/

#include "DISEtype.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               struct intXY                                 *
*****************************************************************************/

intXY operator +( intXY lvalue, intXY rvalue )
{
   intXY ret;
   ret.x = lvalue.x + rvalue.x;
   ret.y = lvalue.y + rvalue.y;
   return ret;
}

intXY operator *( int lvalue, intXY rvalue )
{
   intXY ret;
   ret.x = lvalue*rvalue.x;
   ret.y = lvalue*rvalue.y;
   return ret;
}

/*****************************************************************************
******************************************************************************
****                Module Public Functions Implementation                ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

intXY generateDisplacementVector( Direction::Direction d )
{
   intXY ret = {0,0};
   switch ( d ) {
      case Direction::NORTH :
         ret = Direction::UP_VEC;
         break;
      case Direction::SOUTH :
         ret = Direction::DOWN_VEC;
         break;
      case Direction::EAST :
         ret = Direction::RIGHT_VEC;
         break;
      case Direction::WEST :
         ret = Direction::LEFT_VEC;
         break;
      default:
         break;
   }
   return ret;
}

intXY dir2vec( Direction::Direction direction )
{
   intXY vector;
   switch ( direction ) {
      case Direction::NORTH :
         vector = Direction::UP_VEC;
         break;
      case Direction::SOUTH :
         vector = Direction::DOWN_VEC;
         break;
      case Direction::EAST :
         vector = Direction::RIGHT_VEC;
         break;
      case Direction::WEST :
         vector = Direction::LEFT_VEC;
         break;
      default:
         vector = Direction::NULL_VEC;
         break;
   }
   return vector;
}

