/*****************************************************************************
**************************** TILESET HEADER FILE *****************************
******************************************************************************
*                                                                            *
* Module full name: Graphics Module :: TileSet Sub-Module                    *
*                                                                            *
* Description: Implement the TileSet class. The TileSet class contains back- *
*              ground imagery to draw the tiles. So TileSet class is respon- *
*              sible for the background tiled graphics.                      *
*                                                                            *
* Classes list:                                                              *
*    - class TileSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.01.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, November 2004.                         *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_TILESET_H      // prevent header from
#define DISE_TILESET_H 1    // being included twice

/* Includes */
#include "IGFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

#define TILESET_ID 0X00010000
#define TILE_WIDTH  16
#define TILE_HEIGHT 16

/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: TileSet
 *                                                             *
 * Description: A template for a class, not a template class.
 *                                                             *
 * Member data:                                                *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class TileSet : public IGFXSet {
public:
   TileSet( const int t_w = TILE_WIDTH, const int t_h = TILE_HEIGHT );
   TileSet( const char *filename, const int t_w = TILE_WIDTH, const int t_h = TILE_HEIGHT,
            const unsigned long nr = 0 );
   // Methods
   int getTileWidth()  const { return cw; }
   int getTileHeight() const { return ch; }
   int drawTile( BITMAP *dest, int index, int x, int y ) const;
private:
//   TileSet( const TileSet &rvalue );              // copy constructor
//   TileSet& operator= ( const TileSet &rvalue );  // assignment operator
//   TileSet operator= ( const int &rvalue );
}; // END OF CLASS TileSet DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
