/*****************************************************************************
**************************** LOADGAME HEADER FILE ****************************
******************************************************************************
*                                                                            *
* Module full name: Game Engine Module :: Game Initialization File submodule *
*                                                                            *
* Purpose: Read a game initialization file and compile a game object table.  *
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class GameInfo                                                        *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history:                                                          *
*   Revised last Thursday, 25th February 2005.                               *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos 2005.                                             *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_GAMEINIT_H      // prevent header from
#define DISE_GAMEINIT_H 1    // being included twice

/* Includes */
#include <fstream>

/*
 * A list of Game Engine Objects
 *      Note, how this list is used depends on defining the macros T.
 *      This macro is used for defining the tokens types themselves
 *      as weel as the string version of the tokens.
 */
#define DISE_OBJECT_LIST                                             \
   T(T_TILESET),                                                     \
   T(T_SPRITESET),                                                   \
   T(T_GAMEENGINE),                                                  \
   T(T_PLAYER)




/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;

enum nodebox_infotype {
   CONSTANT,
   VARIABLE,
   TS, //TileSet
   SS, //SpriteSet
   GE  //GameEngine
};

struct nodebox {
   nodebox_infotype type;
   void *ptr;
   nodebox *previous;
   nodebox *next;
};

struct TileSetINFO {
   char filename[64];
   unsigned long idnr;
   int TileWidth;
   int TileHeight;
};

struct SpriteSetINFO {
   char filename[64];
   unsigned long idnr;
   int SpriteWidth;
   int SpriteHeight;
};

struct GraphicEngineINFO {
   int TileSet;
   int SpriteSet;
   int TileWidth;
   int TileHeight;
//   ViewPort viewport;
   int ViewPortOffSetX;
   int ViewPortOffSetY;
};

struct PlayerINFO {
};

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: GameInfo
 *                                                             *
 * Description: Contains the game information.
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/
class GameInfo {
public:
   GameInfo();                                   // default constructor
   virtual ~GameInfo();                          // destructor
   
   int LoadInfoFile( const char *filename );
   int proofReading();

private:
   GameInfo( const GameInfo &rvalue );              // copy constructor
   GameInfo& operator= ( const GameInfo &rvalue );  // assignment operator
//   GameInfo operator= ( const int &rvalue );

   int gettoken( char * );
   
protected:
   std::fstream file;  // file
   
   // data base
   int nodecount;
   nodebox *head;
   nodebox *tail;
}; // END OF CLASS GameInfo DECLARATION


/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/




#endif
/* end of the initial ifndef, don't write more code after this line.
   (unless you know exactly what you're doing by that.) */

/* FINAL IMPORTANT REMARKS:

   Still needs some work!  =)

   Miguel Jos
*/
