/*****************************************************************************
***************************** GFXSET HEADER FILE *****************************
******************************************************************************
*                                                                            *
* Module full name:  Graphics Module :: Basic Sets                           *
*                                                                            *
* Description: Keeps the graphics (kind of!) separed from the the game logic.*
*                                                                            *
* Classes list:                                                              *
*    - class GFXSet;
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history:                                                          *
*    20050207 New data member, idnr.                                         *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, December 2004.                         *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_GFXSET_H      // prevent header from
#define LAMP_GFXSET_H 1    // being included twice

/* Includes */
#include <allegro.h>

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

//#define OK  (0)

/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: GFXSet                                               *
 *                                                             *
 * Description: Keeps a bitmap with game graphics (gfx).
 *                                                             *
 * Member data:                                                *
 *   -> idnr   -- Identification number;                       *
 *   -> gfx    -- BITMAP containing the gfx.                   *
 *                                                             *
 * Member Functions:                                           *
 *   draw      -- Copies a rectangular section of width, w and *
 *                height, h from (sx,sy) to destbmp (x,y)      *
 *                coordinates.                                 *
 *                                                             *
 ***************************************************************/ 
class GFXSet {
public:
   GFXSet() : gfx(0), idnr(0) {}               // Standard Constructor
   explicit GFXSet( unsigned long nr ) : gfx(0), idnr(nr) {}
   explicit GFXSet( const char * filename );   // By file constructor
   explicit GFXSet( BITMAP *bitmap );          // By BITMAP construtor
   virtual ~GFXSet();                          // Destructor
   // Methods
   virtual int loadfile( const char * filename );
   virtual int loadBITMAP( BITMAP *bitmap );
   // Getz
   int getWidth()  const { if(EmptyQ()) return 0; return gfx->w; }
   int getHeight() const { if(EmptyQ()) return 0; return gfx->h; }
   int getNumber() const { return idnr; }
   // Questions
   virtual bool EmptyQ() const { return (gfx == NULL); }
   // Graphics
   virtual int draw( BITMAP *destbmp, int sx, int sy, int x, int y, int w, int h ) const;
   virtual void setColorPalette();
private:
//   GFXSet( const GFXSet &rvalue );              // copy constructor
//   GFXSet& operator= ( const GFXSet &rvalue );  // assignment operator
//   GFXSet operator= ( const int &rvalue );
protected:
   unsigned long idnr; // identification number
   BITMAP *gfx;
}; // END OF CLASS GFXSet DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
