/*****************************************************************************
************************** GRAPHIC ENGINE HEADER FILE ************************
******************************************************************************
*                                                                            *
* Module full name:  Graphic Engine                                          *
*                                                                            *
* Purpose: Deals with the game graphics.                                     *
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class GraphicEngine;                                                  *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Module version: 0.00.000  ( development version 1 beta )                   *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_GRAPHIC_ENGINE_H      // prevent header from
#define LAMP_GRAPHIC_ENGINE_H 1    // being included twice

/* Includes */
#include "thing.h"
#include "map.h"
#include "tileset.h"
#include "SpritSet.h"


/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/


/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/

/***************************************************************
 * class: ViewPort                                             *
 ***************************************************************/
class ViewPort {
public:
   int ax, ay; // anchor values
   int w, h;  // dimentions: width and height
   ViewPort(){}                                   // default constructor
   ViewPort( const int &anchor_x, const int &anchor_y,
             const int &width, const int &height )
   {
      ax = anchor_x;
      ay = anchor_y;
      w = width;
      h = height;
   }
   ~ViewPort(){}                          // destructor
}; // END OF CLASS ViewPort

/***************************************************************
 * class: GraphicEngine
 *                                                             *
 * Description: A template for a class, not a template class.
 *                                                             *
 * Member data:                                                *
 *    -> scrolling   -- Tells if it is in the process of scrol-*
 *                      ling the map.                          *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class GraphicEngine {
public:
   GraphicEngine();                  // default constructor
//   GraphicEngine( ViewPort );
   virtual ~GraphicEngine();         // destructor
   // Getz
   // Setz
   Map* setMap( Map* );
   TileSet* setTileSet( TileSet* );
   IGFXSet* setSpriteSet( SpriteSet* );
   // ViewPort routines
   int moveViewPort( intXY vect ); // vect is a displacement vector
   // Object and Map routines
   // Being routines
   int loadBeing( Being* );
   // Drawing routines
   void clearBuffer();
   int drawBackGround();
   int drawThings();
   int renderFrame();
   int showFrame();

private:
   GraphicEngine( const GraphicEngine &rvalue );              // copy constructor
   GraphicEngine& operator= ( const GraphicEngine &rvalue );  // assignment operator
   GraphicEngine operator= ( const int &rvalue );
int createBuffer();
int createGroundbuff();
void destroyBuffer();
void destroyGroundBuff();

protected:
   struct {
      bool scrolling;
   } flag;
   int tilewidth, tileheight;
   ViewPort vp;
   intXY vpoffset;
   Map *map;
   
   TileSet *tileset;
   SpriteSet *spriteset;
   BITMAP *groundbuff;
   BITMAP *buffer;
}; // END OF CLASS GraphicEngine DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
