/*****************************************************************************
*                         Devas Image Sound Engine                           *
*                              BASIC TYPES                                   *
*                                                                            *
* Description: Contains the definition of basic data types in DISE.          *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, it should be fine."   *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by  Miguel Jos, February 2005.                                  *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISETYPE_H      // prevent header from
#define DISETYPE_H 1    // being included twice

struct intXY {
   signed int x,y;
};

struct shortintXY {
   signed short int x,y;
   
   operator intXY() {     // cast operator
      intXY temp = {x,y};
      return temp;
   }
};

typedef unsigned char UBYTE;
typedef unsigned long ULONG;

union ShapeShifter4 {     // This should have a sizeof 4 bytes
   int        i;
   float      f;
   shortintXY xy;
   void      *ptr;
   char       char4[4];
};

typedef ShapeShifter4 XAPXIF4;

// CONSTANTS

// Unitary Direction vectors
namespace Direction {
   const intXY NULL_VEC  = { 0, 0};
   const intXY LEFT_VEC  = {-1, 0};
   const intXY RIGHT_VEC = {+1, 0};
   const intXY UP_VEC    = { 0,-1};
   const intXY DOWN_VEC  = { 0,+1};

   namespace VECT {
      const intXY NORTH = { 0,-1};
      const intXY SOUTH = { 0,+1};
      const intXY EAST  = {+1, 0};
      const intXY WEST  = {-1, 0};
   }

   enum Direction {
      NORTH     = 0x01,
      SOUTH     = 0x02,
      EAST      = 0x04,
      WEST      = 0x08,
      NORTHEAST = 0x10,
      NORTHWEST = 0x20,
      SOUTHEAST = 0x40,
      SOUTHWEST = 0x80
   };
}

/* Direces

   // PORTUGUS      LATIM
   // esquerda      sinistra
   // direita       dextra
   // cima          super(ior)
   // baixo         infer(ior)
   // para esquerda sinistrorsum   (sinistrorsus)
   // para direita  dextrorsus     (in dexterum)
   // para cima     sublime        (in sublime)   (ad superiora) (ad summum)
   // para baixo    deorsum        (ad imo)
   //  esquerda    sinistra
   //  direita     dextera
   // em cima       supra          (insuper)
   // em baixo      infra
   // de cima       superne        (desuper)
   // de baixo      infra          (subter)

   // atrs         post (pone) (retro)
   //  frente      ante
*/

// intXY OPERATOR OVERLOADING
intXY operator +( intXY lvalue, intXY rvalue );
intXY operator *( int lvalue, intXY rvalue );
intXY generateDisplacementVector( Direction::Direction );
intXY dir2vec( Direction::Direction );


#endif
