/*****************************************************************************
***************************** TILESET MODULE *********************************
* version 0.01.000 ***********************************************************
*********************************************************** November 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class TileSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes: NO ERROR HANDLING!                                                  *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, September 2004.                                     *
*                                                                            *
*****************************************************************************/

#include "TileSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

//PALETTE TileSetColor; // TileSet color palette, mustly used as a dummy.


/* External variables */
extern int DEBUG_TEXT_LINE;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class TileSet                                  *
*****************************************************************************/

// Standard constructor
TileSet::TileSet( const int t_w, const int t_h )
: IGFXSet( t_w, t_h )
{
   idnr = TILESET_ID;
}

// By file constructor
TileSet::TileSet( const char *filename, const int t_w, const int t_h,
 const unsigned long nr )
: IGFXSet( filename, t_w, t_h )
{
   idnr = TILESET_ID | nr;
}


/*
// Copy constructor
TileSet::TileSet( const TileSet &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
TileSet& TileSet::operator= ( const TileSet &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}
*/


//----------------|
// PUBLIC METHODS |
//----------------|

// Draws tile indexed by index in the specified x,y location on the
// destination bitmap, dest.
// Return 0 on success.
int TileSet::drawTile( BITMAP *dest, int index, int x, int y ) const
{
   return draw( dest, index, x,y );
}



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i konw!
// Miguel Jos 2nd August 2004.
