/*****************************************************************************
**************************** GRAPHIC ENGINE MODULE ***************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class GraphicEngine
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include <fstream>
#include "GFXEng.h"
#include "Being.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/**** Uses ****/
using std::endl;
using std::fstream;
using std::ios;


/* External variables */
extern fstream diserrorlog;
extern int DEBUG_TEXT_LINE;

/* Local variables */
static unsigned int TileEngineTimer; // Counts miliseconds

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// GraphicEngine Timer
void GraphicEngine_timer_handler() {
   ++TileEngineTimer;
}
END_OF_FUNCTION(GraphicEngine_timer_handler)

// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class GraphicEngine                          *
*****************************************************************************/

// Default constructor
GraphicEngine::GraphicEngine()
: vp(0,0,20,14), map(0), tileset(0), spriteset(0)
{
   flag.scrolling = false;
   vpoffset.x = vpoffset.y = 0;
   tilewidth = TILEWIDTH;
   tileheight = TILEHEIGHT;

   buffer = groundbuff = 0;
   createBuffer();
}

// Destructor
GraphicEngine::~GraphicEngine()
{
   destroyBuffer();
}

// Copy constructor
GraphicEngine::GraphicEngine( const GraphicEngine &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
GraphicEngine& GraphicEngine::operator= ( const GraphicEngine &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//-----------------|
// PRIVATE METHODS |
//-----------------|

int GraphicEngine::createBuffer()
{
   buffer = create_bitmap( tilewidth*vp.w, tileheight*vp.h );
   if ( buffer == NULL ) {
      diserrorlog << "GraphicEngine::creteBuffer Could not allocate buffer bitmap." << endl;
      return -1;
   }
   return 0;
}

void GraphicEngine::destroyBuffer()
{
   if( buffer != NULL )
      destroy_bitmap(buffer);
}

//----------------|
// PUBLIC METHODS |
//----------------|

// GETZ

// SETZ

// Sets the map pointer and returns previous one
Map* GraphicEngine::setMap( Map *m )
{
   Map *previous = map;
   map = m;
   return previous;
}

// Sets the TileSet pointer and returns previous one
TileSet* GraphicEngine::setTileSet( TileSet *ts )
{
   TileSet *previous = tileset;
   tileset = ts;
   tilewidth = tileset->getTileWidth();
   tileheight = tileset->getTileHeight();
   return previous;
}

// Sets the map pointer and returns previous one
IGFXSet* GraphicEngine::setSpriteSet( SpriteSet *ss )
{
   SpriteSet *previous = spriteset;
   spriteset = ss;
   return previous;
}

//------------------------->
// Move ViewPort routines  >
int GraphicEngine::moveViewPort( intXY vect ) {
   vp.ax += vect.x;
   vp.ay += vect.y;
}
//                         >
//------------------------->

//---------------------\
//-- Drawing routines -->
//---------------------/

void GraphicEngine::clearBuffer()
{ clear_bitmap(buffer); }

int GraphicEngine::renderFrame()
{
   drawBackGround();
   drawThings();
   return 0;
}

// Draws the map
int GraphicEngine::drawBackGround()
{
   int x,y, tx, ty;

   acquire_bitmap( buffer );

   for (int ty = vp.ay, y = 0 ; ty < (vp.ay+vp.h) && ty < map->getHeight() && y < (buffer->h); ++ty, y += tileheight )
      for ( int tx = vp.ax, x = 0 ; tx < (vp.ax+vp.w) && tx < map->getWidth() && x < (buffer->w); ++tx, x+=tilewidth )
      {
         tileset->drawTile( buffer, map->getGround(tx,ty), x, y );
      }

   release_bitmap( buffer );
   return 0;
}

// Draws Things
int GraphicEngine::drawThings()
{
   int x,y, tx, ty;
   Thing *bob = NULL;

   acquire_bitmap( buffer );

   for (int ty = vp.ay, y = 0 ; ty < (vp.ay+vp.h) && ty < map->getHeight() && y < (buffer->h); ++ty, y += tileheight )
      for ( int tx = vp.ax, x = 0 ; tx < (vp.ax+vp.w) && tx < map->getWidth() && x < (buffer->w); ++tx, x+=tilewidth )
      {
         bob = (map->getThing( tx, ty ));
         if( bob != NULL )
            bob->draw( buffer, spriteset, x,y );
      }

   release_bitmap( buffer );
   return 0;
}

// Blits map to screen
int GraphicEngine::showFrame()
{
   acquire_bitmap( screen );
//   clear_bitmap(screen);
//   blit( buffer, screen, 0,0, SCREEN_W/2,SCREEN_H/2, buffer->w, buffer->h );
   stretch_blit(buffer, screen, 0,0, buffer->w, buffer->h, SCREEN_W-2*(buffer->w),SCREEN_H-2*(buffer->h), 2*buffer->w,2*buffer->h);
   release_bitmap( screen );
}

/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
