/*****************************************************************************
**************************** GAME ENGINE MODULE ******************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class GameEngine
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include "GameEng.h"
#include "DISEerr.h"
#include "DISElog.h"
#include "anim.h"

using std::fstream;
using std::ios;
using std::endl;

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
extern int debug_var;
extern int DEBUG_TEXT_LINE;
extern fstream diserrorlog;
extern fstream diselog;

extern unsigned long _AnimTime;

/* Local variables */
static GameEngine *MacLeod = NULL; // There can be only one.

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

// FPS TIMER
volatile int secondscounter;
void fpsTIMER()
{
   ++secondscounter;
}
END_OF_FUNCTION( fpstimer )

void fpsSET( int i )
{
   secondscounter = i;
}


/*****************************************************************************
*                               Class GameEngine                             *
*****************************************************************************/
int GameEngine::GameEngineInstanceCount = 0;

// Default constructor
GameEngine::GameEngine()
{
   ++GameEngineInstanceCount;
   message = GMSG::NULL_MESSAGE;
   maparray    = NULL;
   gfxsetarray = NULL;
   gfxengarray = NULL;
   playerarray = NULL;
   mapcount = playercount = gfxsetcount = gfxengcount = 0;
   
   // Implement singleton like behaviour
   if( GameEngineInstanceCount == 1 && MacLeod == NULL )
      MacLeod = this;
   else diserrorlog << "GameEngine::GameEngine Attemp to reset MacLeod pointer blocked" << endl;

   PseudoLoadGame();
   
   LOCK_VARIABLE(_AnimTime);
   LOCK_FUNCTION(animTIMER);
   if( install_int( animTIMER, 1 ) < 0 )
      diserrorlog << "install_int( animTIMER, 1 ) FAILED!!" << endl;
   else setAnimTime(0);

   LOCK_VARIABLE(secondscounter);
   LOCK_FUNCTION(fpsTIMER);
   if( install_int( fpsTIMER, 1000 ) < 0 )
      diserrorlog << "install_int( fpsTIMER, 1000 ) FAILED!!" << endl;
}

// Destructor
GameEngine::~GameEngine()
{
   DestroyArrays();
   
   if( MacLeod == this ) MacLeod == NULL;
   else {
      diserrorlog << "GameEngine::~GameEngine  MacLeod = " << MacLeod;
      diserrorlog << " || this = " << this;
   }
}

// Copy constructor
GameEngine::GameEngine( const GameEngine &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
GameEngine& GameEngine::operator= ( const GameEngine &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}


//----------------|
// PUBLIC METHODS |
//----------------|

//************* GAME LOOP ***************
int GameEngine::GameLoop()
{
   int fps = 0;
   int segundos = 0;
   char str[80] = "";

   flag.loop = true;
   while( flag.loop )
   {
      retrieveInput();
      processMessage();
      renderFrame();
      // show in screen
      for( int i = 0; i < gfxengcount; ++i ) {
         gfxengarray[i]->showFrame();
      }

      // fps counter
      if( secondscounter > 0 ) {
         sprintf(str,"fps:%3d II sec:%3d",fps,++segundos);
         secondscounter = 0;
         fps = 0;
      }
      textout(screen, font, str, 480,0, makecol(255,100,100));
      fps++;
   }
   return 0;
}


int GameEngine::issueMessage( const Message &msg )
{
   if( messagequeue.enqueue(msg) < 0 ) return -2;
   return 0;
}

//-----------------|
// PRIVATE METHODS |
//-----------------|

//--- SETZ --->

//************* RETRIEVE INPUT ***************
// Gets input
int GameEngine::retrieveInput()
{
   if( !keypressed() ) return 0;
   int tmp_key = readkey();

   for( int i=0; i < playercount; ++i) {
      if ( 0 != playerarray[i]->TranslateKey(tmp_key) ) {
         message = playerarray[i]->UseButton();
         if( message.msg == 0 ) break; // Player used key, but no message was issued.
         issueMessage( message );
         return 0;
      }
      continue;
   }
   
   switch ( tmp_key >> 8 )
   {
      case KEY_LEFT:
         message.param1.i = Direction::WEST;
         break;
      case KEY_RIGHT:
         message.param1.i = Direction::EAST;
         break;
      case KEY_UP:
         message.param1.i = Direction::NORTH;
         break;
      case KEY_DOWN:
         message.param1.i = Direction::SOUTH;
         break;
      case KEY_ESC:
         flag.loop = false;
         textout(screen, font, "Escape Key pressed!",0, 0, makecol(255,0,0));
         return 0;
      default:
         message.msg = GMSG::XCHAR;
         message.param1.i = tmp_key;
         messagequeue.enqueue( message );
         diselog << "XCHAR message queued\n";
         return 0;
   }
   
   message.msg  = GMSG::WALK;
   message.ptr1 = playerarray[0]->getPC();
   message.param2.ptr = maparray[0];
   issueMessage( message );
   return 0;
}

//************* PROCESSMESSAGE ***************
// Decodes and executes messages(orders)
int GameEngine::processMessage()
{
   // Any messages?
   if( messagequeue.emptyQ() ) return 0; // If not then there's nothing here to do!
   // Lets service this message.
   message = messagequeue.dequeue();
   switch (message.msg >> 16)
   {
      case ( GMSG::XCHAR>>16 ):
         diselog << "XCHAR message caught\n";
         break;
         
      case ( GMSG::WALK>>16 ):
         reinterpret_cast<Being*>(message.ptr1)->walk(
            reinterpret_cast<Map*>(message.param2.ptr),
            static_cast<Direction::Direction>(message.param1.i)
         );
         break;
      default:
         return 0;
   }
   
   return 0;
}

//************* RENDER FRAME ***************
// Renders next frame
int GameEngine::renderFrame()
{
   for( int i = 0; i < gfxengcount; ++i ) {
      gfxengarray[i]->renderFrame();
   }

   return 0;
}

//************* PSEUDO LOAD *************
int GameEngine::PseudoLoadGame()
{
   int i;
   char stemp[80] = "";
   char sTileSet[80] = "tilepal.pcx";
   char sCharacterSet[80] = "npc.pcx";
   intXY CharSize = {16,16};
   fstream initfile( "game.ini", ios::in ); // Config file
   
   while( !initfile.eof() ) {
      initfile >> stemp;
      diselog << stemp;
      if( !strcmp("CharacterSet",stemp) ) {
         initfile >> stemp >> sCharacterSet;
         diselog << ' ' << stemp << ' ' << sCharacterSet;
      }
      if( !strcmp("CharacterSizeX",stemp) ) {
         initfile >> stemp >> CharSize.x;
         diselog << ' ' << stemp << ' ' << CharSize.x;
         }
      if( !strcmp("CharacterSizeY",stemp) ) {
         initfile >> stemp >> CharSize.y;
         diselog << ' ' << stemp << ' ' << CharSize.y;
      }
      diselog << endl;
   }
   
   // Creating map
   mapcount = 1;
   maparray = new Map*[mapcount];
   if( maparray != NULL ) {
      for( i=0; i < mapcount; ++i )
         maparray[i] = NULL;
      maparray[0] = new Map( 20,14, grassTile );
   }
   else {
      maparray = NULL;
      mapcount = 0;
   }

   // Loading graphic sets
   gfxsetcount = 2;
   gfxsetarray = new GFXSet*[gfxsetcount];
   if( gfxsetarray != NULL ) {
      for( i=0; i < gfxsetcount; ++i )
         gfxsetarray[i] = NULL;
      gfxsetarray[0] = new TileSet("tilepal.pcx");
      gfxsetarray[1] = new SpriteSet(sCharacterSet,CharSize.x,CharSize.y);
   }
   else {
      gfxsetarray = NULL;
      gfxsetcount = 0;
   }
   
   // Creating GraphicEngine(s)
   gfxengcount = 1;
   gfxengarray = new GraphicEngine*[gfxengcount];
   if( gfxengarray != NULL ) {
      for( i=0; i < gfxengcount; ++i )
         gfxengarray[i] = NULL;
      gfxengarray[0] = new GraphicEngine;
      gfxengarray[0]->setMap(maparray[0]);
      gfxengarray[0]->setTileSet(reinterpret_cast<TileSet*>(gfxsetarray[0]));
      gfxengarray[0]->setSpriteSet(reinterpret_cast<SpriteSet*>(gfxsetarray[1]));
   }
   else {
      gfxengarray = NULL;
      gfxengcount = 0;
   }

   // Creating player
   playercount = 1;
   playerarray = new Player*[playercount];
   if( playerarray != NULL ) {
      for( i=0; i < playercount; ++i )
         playerarray[i] = NULL;
      playerarray[0] = new Player( maparray[0], gfxengarray[0] );
   }
   else {
      playerarray = NULL;
      playercount = 0;
   }
   
   diselog << "GameEngine::PseudoLoadGame counts = " << mapcount
           << ", " << gfxsetcount << ", " << gfxengcount << ", "
           << playercount << endl;

}

int GameEngine::FLoadGame()
{
   //search string \begin{
}


//******* Destroys all allocated arrays **********
int GameEngine::DestroyArrays()
{
   if( maparray != NULL ) {
      while( mapcount > 0 ) {
         --mapcount;
         delete maparray[mapcount];
      }
      delete[] maparray;
   }
   if( gfxsetarray != NULL ) {
      while( gfxsetcount > 0 ) {
         --gfxsetcount;
         delete gfxsetarray[gfxsetcount];
      }
      delete[] gfxsetarray;
   }
   if( gfxengarray != NULL ) {
      while( gfxengcount > 0 ) {
         --gfxengcount;
         delete gfxengarray[gfxengcount];
      }
      delete[] gfxengarray;
   }
   if( playerarray != NULL ) {
      while( playercount > 0 ) {
         --playercount;
         delete playerarray[playercount];
      }
      delete[] playerarray;
   }
   return 0;
}

/*****************************************************************************
******************************************************************************
****               Module Public Functions Implementation                 ****
******************************************************************************
*****************************************************************************/


int IssueMessage( Message m )
{
   if( MacLeod == NULL ) return -1;
   if( ( MacLeod->messagequeue.enqueue( m ) ) < 0 ) return -2;
   return 0;
}

/*****************************************************************************
******************************************************************************
****              Module Private Functions Implementation                 ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
