/*****************************************************************************
******************************       MODULE **********************************
* version 0.00.000 ***********************************************************
*********************************************************** February 2005 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class GameInfo
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos 2004.                                                *
*                                                                            *
*****************************************************************************/

#include "loadgame.h"
#include <iostream>

using std::fstream;
using std::ios;
using std::endl;
using std::cout;



/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static inline bool letterQ( char c ) {
   return ( (c>0x40 && c<0x5B) || (c>0x60 && c<0x7B) );
}
static inline bool numberQ( char c ) {
   return ( c >= 0x30 && c <= 0x39 );
}

/*****************************************************************************
*                               Class XXXX3                                  *
*****************************************************************************/

// Default constructor
GameInfo::GameInfo()
: nodecount(0), head(0), tail(0)
{
   // create and initialize data
}

// Destructor
GameInfo::~GameInfo()
{
   // Clean up after himself. Prevent memory leaks.
}

// Copy constructor
GameInfo::GameInfo( const GameInfo &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
GameInfo& GameInfo::operator= ( const GameInfo &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//-----------------|
// PRIVATE METHODS |
//-----------------|

int GameInfo::gettoken( char *token )
{
   int i = 0;
   char c;
   *token = '\0';

   if( c = file.get() == EOF ) return 0;

   // identifier
   if( letterQ(c) )
      while( letterQ(c) || numberQ(c) )
      {
            *token = c;
            *(++token) = '\0';
            ++i;
            file.get(c);
            if( file.eof() ) break;
      }
   else // number
      if( numberQ(c) )
         while( numberQ(c) || c=='.' || letterQ(c) )
         {
            *token = c;
            *(++token) = '\0';
            ++i;
            file.get(c);
            if( file.eof() ) break;
         }
      else // other
      {
         *token = c;
         *(++token) = '\0';
         ++i;
      }
   return i;
}


//----------------|
// PUBLIC METHODS |
//----------------|
int GameInfo::LoadInfoFile( const char *filename ) {
   file.open( filename, ios::in );
};

int GameInfo::proofReading()
{
   char tok[80];
   
   gettoken(tok);
   strcmp(tok,"Version");

   return 0;
};

/*****************************************************************************
******************************************************************************
****               Module Public Functions Implementation                 ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

