/*********************************************************************
* Test MessageManager
*                                                                    *
* Author: Miguel Jos
*                                                                    *
* Purpose: Test Message and MessageQueue classes.                    *
*                                                                    *
* Usage: A short explanation of how to run the program.              *
*                                                                    *
* References: Creative copying is a legitimate form of programing.   *
*           You should reference the original author of any work you *
*          copied.                                                   *
*                                                                    *
* File formats: List of files that your program reads or writes and  *
*          a short description of their formats.                     *
*                                                                    *
* Restrictions: Like "The program does not check for input errors."  *
*                                                                    *
* Version: 0.00.000                                                  *
*                                                                    *
* Revision history: After reading "C++ How To Program" a book of by  *
*    Deitel & Deitel, i decided to change the identation from three  *
*    to four spaces.                                                 *
*        Designed new comment styles. New comment boxes.             *
*        The opening curly brace "{" of a function definition is now *
*    in the line folowing the function name. The closing one "}" is  *
*    always in a line by herself.                                    *
*                                                                    *
* Error handling: If the program detects an error, what does it do   *
*          whith it?                                                 *
*              What do the error codes mean, if you use error codes? *
*                                                                    *
* Notes: The indentation size is three.                              *
*                                                                    *
* Copyright by Miguel Jos, September 2004.                          *
*********************************************************************/

/**** Includes ****/
#include <iostream>
#include <cstdlib>
#include "MSGman.h"

/**** Uses ****/
using std::cout;
using std::cin;
using std::endl;

/**** #defines / #undef ****/

/**** typedef's ****/

/**** struct's ****/

/*******************
* Global constants *
*******************/

/*******************
* Global Variables *
*******************/

/****************************************************************************/
/**                                                                        **/
/**                                Classes                                 **/
/**                                                                        **/
/****************************************************************************/

/****************************************************************************/
/**                              Classes end                               **/
/****************************************************************************/


/****************************************************************************/
/**                                                                        **/
/**                               Functions                                **/
/**                                                                        **/
/****************************************************************************/

/***************************************************************
 * Function: PrintMenu
 *                                                             *
 * Description:
 * Parameters:
 * Return:
 ***************************************************************/
void PrintMenu()
{
   cout << "\n E : enqueue     \n"
        <<   " D : dequeue     \n"
        <<   " F : fill queue  \n"
        <<   " T : dump queue  \n"
        <<   " X : exit        \n" << endl;
}

void DumpQueue( MessageQueue & mm )
{
   while( mm.messagePendingQ() ) {
      cout << mm.dequeue() << endl;
   }
}

void FillQueue( MessageQueue & mm )
{
   Message mms = {0,0,0};
   for( int i = 0; i < 64; ++i ) {
      mms.param1.i = i;
      mm.enqueue( mms );
   }

}
 
              /*example2*/
/*********************************************
* Triangle -- compute the area of a triangle *
*                                            *
* Parameters                                 *
*  width -- width of triangle                *
*  height -- height of the triangle          *
*                                            *
* Returns                                    *
*  area of the triangle                      *
*********************************************/
// float triangle(float width, float height)
// {
//    return ((width*height)/2);
// }

/****************************************************************************/
/**                    End of functions declarations                       **/
/****************************************************************************/


/*********************************************
*                                            *
*      MM     MM    AA    III  NN     N      *
*      M M   M M   A  A    I   N N    N      *
*      M  M M  M  A    A   I   N  N   N      *
*      M   M   M  AAAAAA   I   N   N  N      *
*      M       M  A    A   I   N    N N      *
*      M       M  A    A  III  N     NN      *
*                                            *
*********************************************/

int main(int argc, char *argv[])               // You just have to have a main!!
{
   bool loop = true;
   char option = 0;
   int dummy;
   Message message = {0,0,0};
   MessageQueue Beatrix;
   
   cout << "MessageQueue test Program\n" << endl;
   

   while ( loop )
   {
      PrintMenu();
      cin >> option;
      switch (option)
      {
         case 'E':
         case 'e':
            cout << "MSG: ";
            cin >> message;
            dummy = Beatrix.enqueue( message );
            if( dummy < 0 )
               cout << "Overflow!" << endl;
            break;
         case 'D':
         case 'd':
            if( Beatrix.queueEmptyQ() ) {
               cout << "Empty!" << endl;
               break;
            }
            cout << Beatrix.dequeue() << endl;
            break;
         case 'F':
         case 'f':
            FillQueue( Beatrix );
            break;
         case 'T':
         case 't':
            DumpQueue( Beatrix );
            break;
         default:
            loop = false;
            break;
      }
   }
   
   cout << "sizeof(intXY) -------- " << sizeof(intXY) << endl;
   cout << "sizeof(shortintXY) --- " << sizeof(shortintXY) << endl;
   cout << "sizeof(UBYTE) -------- " << sizeof(UBYTE) << endl;
   cout << "sizeof(ULONG) -------- " << sizeof(ULONG) << endl;
   cout << "sizeof(Direction) ---- " << sizeof(Direction::Direction) << endl;
   cout << "sizeof(void*) -------- " << sizeof(void*) << endl;
   cout << "sizeof(ShapeShifter4)- " << sizeof(ShapeShifter4) << endl;
   cout << "sizeof(XAPXIF4) ------ " << sizeof(XAPXIF4) << endl;
   system("PAUSE");
   return (0);
}


/*****************************************************************************
 Final coments:
    Well you may have still something to say!
    Before these final coments you may also want to write the body of some
 functions that you've only declared the prototype so be free to do it BEFORE
 the final coments, after all, these ARE the final coments, they come in the
 end.
    You may also want to put here messages like: "This structure of coments as
 been mostly taken from Steve Qualline's Practical C++ Programming." "I have
 not fixed all the bugs yet. You must've noticed that that this file has no
 working code, but at least you will never have another blank sheet before
 starting a program again."

    Coments by Miguel Maltez Jos

        \   /
        0---0
          L
        '---'
          *
*****************************************************************************/
