/*****************************************************************************
****************************** MESSAGE QUEUE *********************************
* version 0.00.000 ***********************************************************
********************************************************** September 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class MessageQueue
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, September 2004.                                     *
*                                                                            *
*****************************************************************************/

#include "MSGQ.H"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
static int Qoverflow_count = 0; // counts the number of times there was a message Q overflow

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                            Class MessageQueue                            *
*****************************************************************************/

// Default constructor
MessageQueue::MessageQueue()
{
   maxsize = MAX_MSGQUEUE_SIZE;
   msgcount = 0;
   head = tail = 0;
   overflow = false;
}

// Destructor
MessageQueue::~MessageQueue()
{
   // Clean up after himself. Prevent memory leaks.
}

// Copy constructor. Do not use it!
MessageQueue::MessageQueue( const MessageQueue &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator. Do not use it!
MessageQueue& MessageQueue::operator= ( const MessageQueue &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//----------------|
// PUBLIC METHODS |
//----------------|

// Returns 0 on success
// Returns -1 if Q is full
int MessageQueue::enqueue( Message message )
{
   if( msgcount >= maxsize ) { // assures that the tail doesn't overlap the head
      overflow = true;
      return -1;
   }

   if( queueEmptyQ() ) {
      tail = head = 0;
   }
   else {                      // this gives a rollover behaviour, much needed,
      if( ++tail == maxsize )  // since the data is not bumped up the array
         tail = 0;             // when something is dequeued
   }
   
   msgq[tail] = message;
   ++msgcount;
   
   return 0;
}

Message MessageQueue::dequeue()
{
   Message temp = GMSG::NULL_MESSAGE;
   if ( queueEmptyQ() )
      return temp;

   overflow = false;

   temp = msgq[head];

   if( ++head >= maxsize )
      head = 0;

   --msgcount;
   
   if( queueEmptyQ() ) {
      head = tail = 0;
   }
   
   return temp;
}

// Inserts a message in the front of the queue instead of the back. (Cutting in line!)
// Returns 0 on success
// Returns -1 if Q is full
int MessageQueue::insertAtFront( Message message )
{
   if( msgcount >= maxsize ) { // assures that the tail doesn't overlap the head
      overflow = true;
      return -1;
   }

   if( queueEmptyQ() ) {
      tail = head = 0;
   }
   else {                      // this gives a rollover behaviour, much needed,
      if( --head < 0 )         // since the data is not bumped up the array
         head = maxsize -1;    // when something is dequeued
   }

   msgq[head] = message;
   ++msgcount;

   return 0;
}

/*****************************************************************************
******************************************************************************
****                 Module Public Functions Prototypes                   ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
