/*****************************************************************************
******************************** MAP MODULE **********************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class Map
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history:
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include <fstream>
#include "Map.h"

using std::endl;

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
extern int DEBUG_TEXT_LINE;
extern std::fstream diserrorlog;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/



/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class Map                                  *
*****************************************************************************/

// Default constructor
Map::Map() : w(0),h(0),sflag(0),tilemap(0), thingrid(0)
{
}

// Destructor
Map::~Map()
{
   if( tilemap != 0 ) {
      delete [] tilemap;
   }
}

// By size constructor.
Map::Map( int width, int height ) {
   if( width <= 0 || height <= 0 ) {
      w = h = 0;
      sflag = 0;
      tilemap = 0;
      return;
   }
   w = width;
   h = height;
   create();
   for( int i=0; i < w*h; ++i )
      tilemap[i].ground = i;
}

// By size constructor with fill.
Map::Map( int width, int height, Tile t )
{
   if( width <= 0 || height <= 0 ) {
      w = h = 0;
      sflag = 0;
      tilemap = 0;
      return;
   }
   w = width;
   h = height;
   create();
   
   for( int i=0; i < w*h; ++i )
      tilemap[i] = t;
      
   textout(screen, font, "Map::Map(int,int,Tile) called",0, DEBUG_TEXT_LINE*10, makecol(255,255,0));
   ++DEBUG_TEXT_LINE;
   readkey();
}

// Copy constructor
Map::Map( const Map &rvalue )
{
   // data = rvalue.data;
}

// OPERATORS

// Assignment
Map& Map::operator= ( const Map &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

/*
Tile& Map::operator()( int x, int y ) {
   return tilemap[ y * w + x ];
} */

//----------------|
// PUBLIC METHODS |
//----------------|

//-- SETZ -->



//-- GETZ -->

UBYTE Map::getGround( const int &x, const int &y )
{
   return tilemap[ y * w + x ].ground;
}

// Returns NULL if there's no thing or the coordinates were invalid.
Thing* Map::getThing(const int &x,const int &y )
{
   if( outOfMapQ(x,y) ) return NULL;
   return thingrid[y*w+x];
}

//-- Questions -->

bool Map::outOfMapQ(const int &x,const int &y ) const
{
   return ( x<0 || y<0 || x >= w || y >= h );
}

bool Map::occupiedQ(const int &x,const int &y ) const
{
   if ( outOfMapQ(x,y) ) return false;
   return ( (tilemap[y*w+x].pad&0x01 == 0x01) &&
            ( thingrid[y*w+x] != NULL )
          );
}

bool Map::walkableQ( intXY pos, Direction::Direction dir )
{
   intXY destpos = pos + generateDisplacementVector( dir );
   if( outOfMapQ(pos.x,pos.y) ) return false;
   if( outOfMapQ(destpos.x,destpos.y) ) return false;
   if( (dir & tilemap[ pos.y * w + pos.x ].walk) != 0 )
      return false; // Can't walk in this direction
   return true;
}

//-- Actions -->

Thing* Map::removeThing( int x, int y )
{
   if( outOfMapQ(x,y) ) return NULL;
   Thing *ptr = thingrid[y*w+x];
   thingrid[y*w+x] = NULL;
   ptr->takenFromMap(); // Deals with some thing internals.
   return ptr;
}

int Map::insertThing( Thing *thingptr, int x, int y )
{
   if( outOfMapQ(x,y) ) return OUTOFMAP;
   if( occupiedQ(x,y) ) return CELL_OCCUPIED;

   thingrid[y*w+x] = thingptr;
   thingptr->castUponMap(x,y);
   setOccupied(x,y); // sets the occupied flag in the map
   return OK;
}

int Map::moveThing( Thing *thingptr, Direction::Direction dir )
{
   intXY oldpos = thingptr->getPosition();
   
   // Data consistency check (i.e. Is the being in this map?)
   if( thingptr != getThing( oldpos.x, oldpos.y ) ) {
      diserrorlog << "Map::moveThing data inconsistency at ("
               << oldpos.x << "," << oldpos.y << ")" << endl;
      return -1;
   }
   // Check walkability
   if( (dir & tilemap[ oldpos.y * w + oldpos.x ].walk) != 0 )
      return CANT_WALK; // Can't walk in this direction
      
   intXY newpos = (oldpos + generateDisplacementVector(dir));
   
   if( outOfMapQ(newpos.x,newpos.y) ) return CELL_OUTOFMAP;
   if( occupiedQ(newpos.x,newpos.y) ) return CELL_OCCUPIED;

   // it seems all's OK so lets move the pointer
   thingrid[ newpos.y * w + newpos.x ] = thingrid[ oldpos.y * w + oldpos.x ];
   setOccupied( newpos.x, newpos.y );
   
   thingrid[ oldpos.y * w + oldpos.x ] = NULL;
   clearOccupied( oldpos.x, oldpos.y );
   
   thingptr->setPosition( newpos );
   return OK;
}


//-------------------|
// PROTECTED METHODS |
//-------------------|


//-----------------|
// PRIVATE METHODS |
//-----------------|

int Map::create()
{
   tilemap = new Tile[w*h];
   thingrid = new Thing*[w*h];
   for ( int i = 0; i < w*h; ++i ) {
      thingrid[i] = NULL;
   }
}


/*****************************************************************************
*                  Module Private Functions Implementation                   *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}
