/*****************************************************************************
**************************** THING HEADER FILE *******************************
******************************************************************************
*                                                                            *
* Module full name:  Thing Module
*                                                                            *
* Description:                                                               *
*
*                                                                            *
* Classes list:                                                              *
*    - class Thing
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_THING_H      // prevent header from
#define LAMP_THING_H 1    // being included twice

/* Includes */
#include "DISEtype.h"
#include <allegro.h>
#include "GFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;

// Types of things
namespace ThingType {
   enum ThingType {
      BEING  = 0x01000000,
      OBJECT = 0x02000000
   };
}


 //---------------------------------------------------------------------------||
// BEGIN NAMESPACE THING -----------------------------------------------------\/
namespace THING {

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// Thing status flags
const ULONG CLEAR       = 0x00;
const ULONG INMAP       = 0x01;
const ULONG INCONTAINER = 0x02;
const ULONG SOLID       = 0x04;

}// END OF THING NAMESPACE ---------------------------------------------------/\
//----------------------------------------------------------------------------||

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/

/***************************************************************
 * Class: Thing                                                *
 *                                                             *
 * Description: Represents things that reside on a map.        *
 *                                                             *
 * Member data:                                                *
 *    -> ID       -- General identification number, everyThing *
 *                   in the game has one.                      *
 *    -> type     --                                           *
 *    -> fstatus  -- status flag
 *    -> pos      -- thing's current location in map (if it isn't in a map the value has no meaning)
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class Thing {
public:
   Thing();                                   // default constructor
   virtual ~Thing();                          // destructor
   // METHODS
   // Getz
   virtual ULONG getID() { return ID; }
   virtual ULONG getType() { return type; }
   virtual intXY getPosition() { return pos; }
   // Setz
   virtual void setPosition( intXY coord );
   virtual void setPosition( int x, int y );
   // Questions
   virtual bool limboQ();
   virtual bool inMapQ();
   virtual bool solidQ();
   // Other
   virtual void castUponMap( int x, int y );
   virtual void takenFromMap();
   // Graphics
   virtual int draw( BITMAP *dest, int x, int y );
   virtual int draw( BITMAP *dest, GFXSet*, int x, int y );
private:
   Thing( const Thing &rvalue );              // copy constructor
   Thing& operator= ( const Thing &rvalue );  // assignment operator
//   Thing operator= ( const int &rvalue );
protected:
   // Flagz
   void setFlag(ULONG f) { fStatus |= f; }
   void clearFlag(ULONG f) { fStatus &= ~(f); }
   
protected:
   Thing( ULONG IDnr, ULONG type_ );

   ULONG ID;
   ULONG type;
   ULONG fStatus;
   
   intXY pos;
}; // END OF CLASS Thing DECLARATION


/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/

#endif
